/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateGroupListener
implements ProcessEventListener {
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        UpdateGroupProcessForm form = (UpdateGroupProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(context.getProcessForm().getInlongGroupId());
        UpdateGroupProcessForm.OperateType operateType = form.getOperateType();
        String username = context.getApplicant();
        if (groupInfo != null) {
            switch (operateType) {
                case SUSPEND: {
                    this.groupService.updateStatus(groupInfo.getInlongGroupId(), GroupState.SUSPENDING.getCode(), username);
                    break;
                }
                case RESTART: {
                    this.groupService.updateStatus(groupInfo.getInlongGroupId(), GroupState.RESTARTING.getCode(), username);
                    break;
                }
                case DELETE: {
                    this.groupService.updateStatus(groupInfo.getInlongGroupId(), GroupState.DELETING.getCode(), username);
                    break;
                }
            }
        } else {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        form.setGroupInfo(groupInfo);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

