/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupResetRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupProcessService.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(10, 20, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("inlong-group-process-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowQueryService workflowQueryService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongStreamService streamService;

    public WorkflowResult startProcess(String groupId, String operator) {
        LOGGER.info("begin to start approve process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.TO_BE_APPROVAL.getCode(), operator);
        ApplyGroupProcessForm form = this.genApplyGroupProcessForm(groupId);
        WorkflowResult result = this.workflowService.start(ProcessName.APPLY_GROUP_PROCESS, operator, (ProcessForm)form);
        List tasks = result.getNewTasks();
        if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
            throw new BusinessException(ErrorCodeEnum.WORKFLOW_START_RECORD_FAILED, String.format("failed to start inlong group for groupId=%s", groupId));
        }
        LOGGER.info("success to start approve process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        return result;
    }

    public String suspendProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to suspend process asynchronously for groupId={} by operator={}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_OFFLINE_ING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.SUSPEND);
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(ProcessName.SUSPEND_GROUP_PROCESS, userInfo, (ProcessForm)form));
        LOGGER.info("success to suspend process asynchronously for groupId={} by operator={}", (Object)groupId, (Object)operator);
        return groupId;
    }

    public WorkflowResult suspendProcess(String groupId, String operator) {
        LOGGER.info("begin to suspend process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_OFFLINE_ING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.SUSPEND);
        WorkflowResult result = this.workflowService.start(ProcessName.SUSPEND_GROUP_PROCESS, operator, (ProcessForm)form);
        List tasks = result.getNewTasks();
        if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
            throw new BusinessException(ErrorCodeEnum.WORKFLOW_SUSPEND_RECORD_FAILED, String.format("failed to suspend inlong group for groupId=%s", groupId));
        }
        LOGGER.info("success to suspend process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        return result;
    }

    public String restartProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to restart process asynchronously for groupId={} by operator={}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ONLINE_ING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.RESTART);
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(ProcessName.RESTART_GROUP_PROCESS, userInfo, (ProcessForm)form));
        LOGGER.info("success to restart process asynchronously for groupId={} by operator={}", (Object)groupId, (Object)operator);
        return groupId;
    }

    public WorkflowResult restartProcess(String groupId, String operator) {
        LOGGER.info("begin to restart process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ONLINE_ING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.RESTART);
        WorkflowResult result = this.workflowService.start(ProcessName.RESTART_GROUP_PROCESS, operator, (ProcessForm)form);
        List tasks = result.getNewTasks();
        if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
            throw new BusinessException(ErrorCodeEnum.WORKFLOW_RESTART_RECORD_FAILED, String.format("failed to restart inlong group for groupId=%s", groupId));
        }
        LOGGER.info("success to restart process for groupId={} by operator={}", (Object)groupId, (Object)operator);
        return result;
    }

    public String deleteProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to delete group asynchronously for groupId={} by user={}", (Object)groupId, (Object)operator);
        EXECUTOR_SERVICE.execute(() -> {
            try {
                this.invokeDeleteProcess(groupId, operator);
            }
            catch (Exception e) {
                LOGGER.error(String.format("failed to async delete group for groupId=%s by %s", groupId, operator), (Throwable)e);
                throw e;
            }
        });
        LOGGER.info("success to delete group asynchronously for groupId={} by user={}", (Object)groupId, (Object)operator);
        return groupId;
    }

    public Boolean deleteProcess(String groupId, String operator) {
        LOGGER.info("begin to delete group for groupId={} by user={}", (Object)groupId, (Object)operator);
        try {
            this.invokeDeleteProcess(groupId, operator);
        }
        catch (Exception e) {
            LOGGER.error(String.format("failed to delete group for groupId=%s by user=%s", groupId, operator), (Throwable)e);
            throw e;
        }
        LOGGER.info("success to delete group for groupId={} by user={}", (Object)groupId, (Object)operator);
        return true;
    }

    public Boolean deleteProcess(String groupId, UserInfo opInfo) {
        List<String> inCharges;
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.GROUP_NOT_FOUND, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        if (!opInfo.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()) && !(inCharges = Arrays.asList(entity.getInCharges().split(","))).contains(opInfo.getName())) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED);
        }
        InlongGroupInfo groupInfo = this.groupService.doDeleteCheck(groupId, opInfo.getName());
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.DELETE);
        WorkflowResult result = this.workflowService.start(ProcessName.DELETE_GROUP_PROCESS, opInfo.getName(), (ProcessForm)form);
        List tasks = result.getNewTasks();
        if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
            throw new BusinessException(ErrorCodeEnum.WORKFLOW_DELETE_RECORD_FAILED, String.format("failed to delete inlong group for groupId=%s", groupId));
        }
        return true;
    }

    public boolean resetGroupStatus(InlongGroupResetRequest request, String operator) {
        boolean result;
        LOGGER.info("begin to reset group status by operator={} for request={}", (Object)operator, (Object)request);
        String groupId = request.getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        Preconditions.expectNotNull((Object)groupInfo, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        GroupStatus status = GroupStatus.forCode((int)groupInfo.getStatus());
        switch (status) {
            case CONFIG_ING: 
            case CONFIG_OFFLINE_ING: 
            case CONFIG_ONLINE_ING: 
            case CONFIG_DELETING: {
                int rerunProcess = request.getRerunProcess();
                int resetFinalStatus = request.getResetFinalStatus();
                result = this.pendingGroupOpt(groupInfo, operator, status, rerunProcess, resetFinalStatus);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported status to reset groupId=%s and status=%s", request.getInlongGroupId(), status));
            }
        }
        LOGGER.info("finish to reset group status by operator={}, result={} for request={}", new Object[]{operator, result, request});
        return result;
    }

    private boolean pendingGroupOpt(InlongGroupInfo groupInfo, String operator, GroupStatus status, int rerunProcess, int resetFinalStatus) {
        String groupId = groupInfo.getInlongGroupId();
        if (rerunProcess == 1) {
            ProcessRequest processQuery = new ProcessRequest();
            processQuery.setInlongGroupId(groupId);
            List entities = this.workflowQueryService.listProcessEntity(processQuery);
            entities.sort(Comparator.comparingInt(WorkflowProcessEntity::getId));
            WorkflowProcessEntity lastProcess = (WorkflowProcessEntity)entities.get(entities.size() - 1);
            UserInfo userInfo = LoginUserUtils.getLoginUser();
            EXECUTOR_SERVICE.execute(() -> this.workflowService.continueProcessAsync(lastProcess.getId(), userInfo, "Reset group status"));
            return true;
        }
        if (resetFinalStatus == 1) {
            GroupStatus finalStatus = this.getFinalStatus(status);
            return this.groupService.updateStatus(groupId, finalStatus.getCode(), operator);
        }
        return this.groupService.updateStatus(groupId, GroupStatus.CONFIG_FAILED.getCode(), operator);
    }

    private GroupStatus getFinalStatus(GroupStatus pendingStatus) {
        switch (pendingStatus) {
            case CONFIG_ING: 
            case CONFIG_ONLINE_ING: {
                return GroupStatus.CONFIG_SUCCESSFUL;
            }
            case CONFIG_OFFLINE_ING: {
                return GroupStatus.CONFIGURATION_OFFLINE;
            }
        }
        return GroupStatus.CONFIG_DELETED;
    }

    private void invokeDeleteProcess(String groupId, String operator) {
        InlongGroupInfo groupInfo = this.groupService.doDeleteCheck(groupId, operator);
        GroupResourceProcessForm form = this.genGroupResourceProcessForm(groupInfo, GroupOperateType.DELETE);
        WorkflowResult result = this.workflowService.start(ProcessName.DELETE_GROUP_PROCESS, operator, (ProcessForm)form);
        List tasks = result.getNewTasks();
        if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
            String errMsg = String.format("failed to delete inlong group for groupId=%s", groupId);
            LOGGER.error(errMsg);
            throw new WorkflowListenerException(errMsg);
        }
    }

    private ApplyGroupProcessForm genApplyGroupProcessForm(String groupId) {
        ApplyGroupProcessForm form = new ApplyGroupProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        form.setGroupInfo(groupInfo);
        List<InlongStreamBriefInfo> infoList = this.streamService.listBriefWithSink(groupInfo.getInlongGroupId());
        form.setStreamInfoList(infoList);
        return form;
    }

    private GroupResourceProcessForm genGroupResourceProcessForm(InlongGroupInfo groupInfo, GroupOperateType operateType) {
        GroupResourceProcessForm form = new GroupResourceProcessForm();
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamInfo> streamList = this.streamService.list(groupId);
        form.setStreamInfos(streamList);
        form.setGroupInfo(groupInfo);
        form.setGroupOperateType(operateType);
        return form;
    }
}

