/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSink;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSinkDTO;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSinkRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSinkOperator.class);
    private static final String KEY_FIELDS = "fieldNames";
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "ES".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "ES";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        ElasticsearchSinkRequest sinkRequest = (ElasticsearchSinkRequest)request;
        try {
            ElasticsearchSinkDTO dto = ElasticsearchSinkDTO.getFromRequest((ElasticsearchSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            InlongStreamEntity stream = this.inlongStreamEntityMapper.selectByIdentifier(request.getInlongGroupId(), request.getInlongStreamId());
            dto.setSeparator(String.valueOf((char)Integer.parseInt(stream.getDataSeparator())));
            InlongStreamExtParam streamExt = (InlongStreamExtParam)JsonUtils.parseObject((String)stream.getExtParams(), InlongStreamExtParam.class);
            dto.setFieldOffset(streamExt.getExtendedFieldSize());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Elasticsearch SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        ElasticsearchSink sink = new ElasticsearchSink();
        if (entity == null) {
            return sink;
        }
        ElasticsearchSinkDTO dto = ElasticsearchSinkDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = this.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }

    @Override
    public Map<String, String> parse2IdParams(StreamSinkEntity streamSink, List<String> fields, DataNodeInfo dataNodeInfo) {
        Map<String, String> idParams = super.parse2IdParams(streamSink, fields, dataNodeInfo);
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            sb.append(field).append(" ");
        }
        idParams.computeIfAbsent(KEY_FIELDS, k -> sb.toString());
        return idParams;
    }

    @Override
    public void saveFieldOpt(SinkRequest request) {
        List fieldList = request.getSinkFieldList();
        LOGGER.debug("begin to save es sink fields={}", (Object)fieldList);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<StreamSinkFieldEntity> entityList = new ArrayList<StreamSinkFieldEntity>(size);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sinkType = request.getSinkType();
        Integer sinkId = request.getId();
        for (SinkField fieldInfo : fieldList) {
            this.checkFieldInfo(fieldInfo);
            StreamSinkFieldEntity fieldEntity = (StreamSinkFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSinkFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            try {
                ElasticsearchFieldInfo dto = ElasticsearchFieldInfo.getFromRequest((SinkField)fieldInfo);
                fieldEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            }
            catch (Exception e) {
                throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Elasticsearch FieldInfo failure: %s", e.getMessage()));
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSinkType(sinkType);
            fieldEntity.setSinkId(sinkId);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sinkFieldMapper.insertAll(entityList);
        LOGGER.debug("success to save es sink fields");
    }

    @Override
    public List<SinkField> getSinkFields(Integer sinkId) {
        List sinkFieldEntities = this.sinkFieldMapper.selectBySinkId(sinkId);
        ArrayList<SinkField> fieldList = new ArrayList<SinkField>();
        if (CollectionUtils.isEmpty((Collection)sinkFieldEntities)) {
            return fieldList;
        }
        sinkFieldEntities.forEach(field -> {
            SinkField sinkField = new SinkField();
            if (StringUtils.isNotBlank((CharSequence)field.getExtParams())) {
                ElasticsearchFieldInfo elasticsearchFieldInfo = ElasticsearchFieldInfo.getFromJson((String)field.getExtParams());
                CommonBeanUtils.copyProperties((Object)field, (Object)elasticsearchFieldInfo, (boolean)true);
                fieldList.add((SinkField)elasticsearchFieldInfo);
            } else {
                CommonBeanUtils.copyProperties((Object)field, (Object)sinkField, (boolean)true);
                fieldList.add(sinkField);
            }
        });
        return fieldList;
    }
}

