/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.queue;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueResourceListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(QueueResourceListener.class);
    private static final Integer TIMEOUT_SECONDS = 180;
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(10, 20, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("inlong-mq-process-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private QueueResourceOperatorFactory queueOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        return this.isGroupProcessForm(context);
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = groupProcessForm.getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            String msg = "inlong group not found with groupId=" + groupId;
            log.error(msg);
            throw new WorkflowListenerException(msg);
        }
        groupProcessForm.setGroupInfo(groupInfo);
        groupProcessForm.setStreamInfos(this.streamService.list(groupId));
        String operator = context.getOperator();
        GroupOperateType operateType = groupProcessForm.getGroupOperateType();
        if (InlongConstants.DATASYNC_MODE.equals(groupInfo.getInlongGroupMode())) {
            log.warn("skip to execute QueueResourceListener as sync mode for groupId={}", (Object)groupId);
            if (GroupOperateType.INIT.equals((Object)operateType)) {
                this.createQueueForStreams(groupInfo, groupProcessForm.getStreamInfos(), operator);
            }
            return ListenerResult.success((String)"skip - disable create mq resource for sync mode");
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(groupInfo.getEnableCreateResource())) {
            log.warn("skip to execute QueueResourceListener as disable create resource for groupId={}", (Object)groupId);
            return ListenerResult.success((String)"skip - disable create resource");
        }
        QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupInfo.getMqType());
        switch (operateType) {
            case INIT: {
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ING.getCode(), operator);
                queueOperator.createQueueForGroup(groupInfo, operator);
                this.createQueueForStreams(groupInfo, groupProcessForm.getStreamInfos(), operator);
                break;
            }
            case DELETE: {
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_DELETING.getCode(), operator);
                queueOperator.deleteQueueForGroup(groupInfo, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
        log.info("success to execute QueueResourceListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success((String)"success");
    }

    private void createQueueForStreams(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfos, String operator) {
        String groupId = groupInfo.getInlongGroupId();
        log.info("success to start stream process for groupId={}", (Object)groupId);
        for (InlongStreamInfo stream : streamInfos) {
            StreamResourceProcessForm form = StreamResourceProcessForm.getProcessForm((InlongGroupInfo)groupInfo, (InlongStreamInfo)stream, (GroupOperateType)GroupOperateType.INIT);
            String streamId = stream.getInlongStreamId();
            String errMsg = "failed to start stream process for groupId=" + groupId + " streamId=" + streamId;
            UserInfo userInfo = LoginUserUtils.getLoginUser();
            CompletionStage future = CompletableFuture.supplyAsync(() -> this.workflowService.startAsync(ProcessName.CREATE_STREAM_RESOURCE, userInfo, (ProcessForm)form), EXECUTOR_SERVICE).whenComplete((result, ex) -> {
                if (ex != null) {
                    log.error(errMsg + ": " + ex.getMessage());
                    throw new WorkflowListenerException(errMsg, ex);
                }
                List tasks = result.getNewTasks();
                if (TaskStatus.FAILED == ((TaskResponse)tasks.get(tasks.size() - 1)).getStatus()) {
                    log.error(errMsg);
                    throw new WorkflowListenerException(errMsg);
                }
            });
            try {
                ((CompletableFuture)future).get(TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS);
            }
            catch (Exception e) {
                String msg = "failed to execute stream process in asynchronously ";
                log.error(msg, (Throwable)e);
                throw new WorkflowListenerException(msg + ": " + e.getMessage());
            }
        }
        log.info("success to start stream process for groupId={}", (Object)groupId);
    }
}

