/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.hive;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeDTO;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeInfo;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.hive.HiveJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HiveDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "HIVE";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        HiveDataNodeInfo hiveDataNodeInfo = new HiveDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)hiveDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            HiveDataNodeDTO dto = HiveDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)hiveDataNodeInfo);
        }
        return hiveDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        HiveDataNodeRequest hiveDataNodeRequest = (HiveDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)hiveDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            HiveDataNodeDTO dto = HiveDataNodeDTO.getFromRequest((HiveDataNodeRequest)hiveDataNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Hive node: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(DataNodeRequest request) {
        String url = request.getUrl();
        String username = request.getUsername();
        String password = request.getToken();
        Preconditions.expectNotBlank((String)url, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
        try (Connection ignored = HiveJdbcUtils.getConnection(url, username, password);){
            LOGGER.info("hive connection not null - connection success for url={}, username={}, password={}", new Object[]{url, username, password});
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("hive connection failed for url=%s, username=%s, password=%s", url, username, password);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

