/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.doris;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.pojo.node.doris.DorisDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.doris.DorisSink;
import org.apache.inlong.manager.pojo.sink.doris.DorisSinkDTO;
import org.apache.inlong.manager.pojo.sink.doris.DorisSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DorisSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DorisSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "DORIS".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "DORIS";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        DorisSinkRequest sinkRequest = (DorisSinkRequest)request;
        try {
            DorisSinkDTO dto = DorisSinkDTO.getFromRequest((DorisSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Doris SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSink getFromEntity(@NotNull StreamSinkEntity entity) {
        DorisSink sink = new DorisSink();
        if (entity == null) {
            return sink;
        }
        DorisSinkDTO dto = DorisSinkDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getFeNodes())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "doris fe nodes unspecified and data node is blank");
            }
            DorisDataNodeInfo dataNodeInfo = (DorisDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(entity.getDataNodeName(), entity.getSinkType());
            dto.setFeNodes(dataNodeInfo.getUrl());
            dto.setUsername(dataNodeInfo.getUsername());
            dto.setPassword(dataNodeInfo.getToken());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = this.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }
}

