/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.binlog;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSource;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSourceDTO;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BinlogSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "MYSQL_BINLOG".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "MYSQL_BINLOG";
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        MySQLBinlogSourceDTO mySQLBinlogSourceDTO = (MySQLBinlogSourceDTO)JsonUtils.parseObject((String)sourceEntity.getExtParams(), MySQLBinlogSourceDTO.class);
        if (Objects.nonNull(mySQLBinlogSourceDTO) && StringUtils.isBlank((CharSequence)mySQLBinlogSourceDTO.getHostname())) {
            MySQLDataNodeInfo dataNodeInfo = (MySQLDataNodeInfo)this.dataNodeService.get(sourceEntity.getDataNodeName(), "MYSQL");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)mySQLBinlogSourceDTO, (boolean)true);
            mySQLBinlogSourceDTO.setUser(dataNodeInfo.getUsername());
            mySQLBinlogSourceDTO.setPassword(dataNodeInfo.getToken());
            mySQLBinlogSourceDTO.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            mySQLBinlogSourceDTO.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
            return JsonUtils.toJsonString((Object)mySQLBinlogSourceDTO);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        MySQLBinlogSourceRequest sourceRequest = (MySQLBinlogSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            MySQLBinlogSourceDTO dto = MySQLBinlogSourceDTO.getFromRequest((MySQLBinlogSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of MySQLBinlog SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        MySQLBinlogSource source = new MySQLBinlogSource();
        if (entity == null) {
            return source;
        }
        MySQLBinlogSourceDTO dto = MySQLBinlogSourceDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getHostname())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, "mysql url and data node is blank");
            }
            MySQLDataNodeInfo dataNodeInfo = (MySQLDataNodeInfo)this.dataNodeService.get(entity.getDataNodeName(), "MYSQL");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            dto.setUser(dataNodeInfo.getUsername());
            dto.setPassword(dataNodeInfo.getToken());
            dto.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            dto.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }
}

