/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.pulsar;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSource;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSource;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSourceDTO;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSourceRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.apache.inlong.sort.protocol.enums.PulsarScanStartupMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PulsarSourceOperator
extends AbstractSourceOperator {
    private static final String AUTH_CLASSNAME_KEY = "properties.auth-plugin-classname";
    private static final String AUTH_CLASSNAME_VALUE = "org.apache.pulsar.client.impl.auth.AuthenticationToken";
    private static final String AUTH_PARAMS_KEY = "properties.auth-params";
    private static final String AUTH_PARAMS_VALUE = "token:%s";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private StreamSinkEntityMapper sinkMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "PULSAR".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "PULSAR";
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        PulsarSourceDTO pulsarSourceDTO = (PulsarSourceDTO)JsonUtils.parseObject((String)sourceEntity.getExtParams(), PulsarSourceDTO.class);
        if (Objects.nonNull(pulsarSourceDTO) && StringUtils.isBlank((CharSequence)pulsarSourceDTO.getAdminUrl())) {
            PulsarDataNodeInfo dataNodeInfo = (PulsarDataNodeInfo)this.dataNodeService.get(sourceEntity.getDataNodeName(), "PULSAR");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)pulsarSourceDTO, (boolean)true);
            return JsonUtils.toJsonString((Object)pulsarSourceDTO);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        PulsarSourceRequest sourceRequest = (PulsarSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            PulsarSourceDTO dto = PulsarSourceDTO.getFromRequest((PulsarSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Pulsar SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        PulsarSource source = new PulsarSource();
        if (entity == null) {
            return source;
        }
        PulsarSourceDTO dto = PulsarSourceDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getAdminUrl())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "pulsar admin url unspecified and data node is blank");
            }
            PulsarDataNodeInfo dataNodeInfo = (PulsarDataNodeInfo)this.dataNodeService.get(entity.getDataNodeName(), "PULSAR");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }

    @Override
    public Map<String, List<StreamSource>> getSourcesMap(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfos, List<StreamSource> streamSources) {
        ClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "PULSAR");
        PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)clusterInfo;
        String adminUrl = pulsarCluster.getAdminUrl();
        String serviceUrl = pulsarCluster.getUrl();
        String tenant = ((InlongPulsarInfo)groupInfo).getPulsarTenant();
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = pulsarCluster.getPulsarTenant();
        }
        HashMap sourceMap = Maps.newHashMap();
        for (InlongStreamInfo streamInfo : streamInfos) {
            PulsarSource pulsarSource = new PulsarSource();
            String streamId = streamInfo.getInlongStreamId();
            pulsarSource.setSourceName(streamId);
            pulsarSource.setPulsarTenant(tenant);
            pulsarSource.setNamespace(groupInfo.getMqResource());
            pulsarSource.setTopic(streamInfo.getMqResource());
            pulsarSource.setAdminUrl(adminUrl);
            pulsarSource.setServiceUrl(serviceUrl);
            pulsarSource.setInlongComponent(true);
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataType())) {
                String serializationType = DataTypeEnum.forType((String)streamInfo.getDataType()).getType();
                pulsarSource.setSerializationType(serializationType);
            }
            pulsarSource.setWrapType(streamInfo.getWrapType());
            pulsarSource.setIgnoreParseError(streamInfo.getIgnoreParseError().booleanValue());
            if (StringUtils.isNotBlank((CharSequence)pulsarCluster.getToken())) {
                Map properties = pulsarSource.getProperties();
                properties.putIfAbsent(AUTH_CLASSNAME_KEY, AUTH_CLASSNAME_VALUE);
                properties.putIfAbsent(AUTH_PARAMS_KEY, String.format(AUTH_PARAMS_VALUE, pulsarCluster.getToken()));
            }
            for (StreamSource sourceInfo : streamSources) {
                if (!com.google.common.base.Objects.equal((Object)streamId, (Object)sourceInfo.getInlongStreamId())) continue;
                List sinkEntityList = this.sinkMapper.selectByRelatedId(groupInfo.getInlongGroupId(), streamId);
                if (sinkEntityList.size() == 1) {
                    String sub = String.format("%s_%s_%s_consumer_group", groupInfo.getInlongClusterTag(), pulsarSource.getTopic(), ((StreamSinkEntity)sinkEntityList.get(0)).getId());
                    pulsarSource.setSubscription(sub);
                }
                pulsarSource.setSerializationType(this.getSerializationType(sourceInfo, streamInfo.getDataType()));
                if (!"KAFKA".equals(sourceInfo.getSourceType())) continue;
                pulsarSource.setPrimaryKey(((KafkaSource)sourceInfo).getPrimaryKey());
            }
            if (StringUtils.isEmpty((CharSequence)pulsarSource.getSerializationType())) {
                pulsarSource.setSerializationType(DataTypeEnum.CSV.getType());
            }
            if (DataTypeEnum.CSV.getType().equalsIgnoreCase(pulsarSource.getSerializationType())) {
                pulsarSource.setDataSeparator(streamInfo.getDataSeparator());
                if (StringUtils.isEmpty((CharSequence)pulsarSource.getDataSeparator())) {
                    pulsarSource.setDataSeparator(String.valueOf(44));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)pulsarSource.getSubscription())) {
                pulsarSource.setScanStartupMode(PulsarScanStartupMode.EXTERNAL_SUBSCRIPTION.getValue());
            } else {
                pulsarSource.setScanStartupMode(PulsarScanStartupMode.EARLIEST.getValue());
            }
            pulsarSource.setFieldList(streamInfo.getFieldList());
            sourceMap.computeIfAbsent(streamId, key -> Lists.newArrayList()).add(pulsarSource);
        }
        return sourceMap;
    }
}

