/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.tubemq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSource;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceDTO;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TubeMQSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private StreamSinkEntityMapper sinkMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "TUBEMQ".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "TUBEMQ";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        TubeMQSourceRequest sourceRequest = (TubeMQSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            TubeMQSourceDTO dto = TubeMQSourceDTO.getFromRequest((TubeMQSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of TubeMQ SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        TubeMQSource source = new TubeMQSource();
        if (entity == null) {
            return source;
        }
        TubeMQSourceDTO dto = TubeMQSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }

    @Override
    public Map<String, List<StreamSource>> getSourcesMap(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfos, List<StreamSource> streamSources) {
        ClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "TUBEMQ");
        TubeClusterInfo tubeClusterInfo = (TubeClusterInfo)clusterInfo;
        String masterRpc = tubeClusterInfo.getUrl();
        HashMap sourceMap = Maps.newHashMap();
        streamInfos.forEach(streamInfo -> {
            TubeMQSource tubeMQSource = new TubeMQSource();
            String streamId = streamInfo.getInlongStreamId();
            tubeMQSource.setSourceName(streamId);
            tubeMQSource.setTopic(groupInfo.getMqResource());
            List sinkEntityList = this.sinkMapper.selectByRelatedId(groupInfo.getInlongGroupId(), streamId);
            String consumeGroup = streamId;
            if (sinkEntityList.size() == 1) {
                consumeGroup = String.format("%s_%s_%s_consumer_group", groupInfo.getInlongClusterTag(), groupInfo.getMqResource(), ((StreamSinkEntity)sinkEntityList.get(0)).getId());
            }
            tubeMQSource.setConsumeGroup(consumeGroup);
            tubeMQSource.setMasterRpc(masterRpc);
            tubeMQSource.setWrapType(streamInfo.getWrapType());
            tubeMQSource.setIgnoreParseError(streamInfo.getIgnoreParseError().booleanValue());
            for (StreamSource sourceInfo : streamSources) {
                if (!Objects.equals(streamId, sourceInfo.getInlongStreamId())) continue;
                tubeMQSource.setSerializationType(this.getSerializationType(sourceInfo, streamInfo.getDataType()));
            }
            if (DataTypeEnum.CSV.getType().equalsIgnoreCase(tubeMQSource.getSerializationType())) {
                tubeMQSource.setDataSeparator(streamInfo.getDataSeparator());
                if (StringUtils.isBlank((CharSequence)tubeMQSource.getDataSeparator())) {
                    tubeMQSource.setDataSeparator(String.valueOf(44));
                }
            }
            tubeMQSource.setFieldList(streamInfo.getFieldList());
            sourceMap.computeIfAbsent(streamId, key -> Lists.newArrayList()).add(tubeMQSource);
        });
        return sourceMap;
    }
}

