/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.audit;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.AuditSourceType;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.audit.AbstractAuditSourceOperator;
import org.springframework.stereotype.Service;

@Service
public class AuditSourceElasticsearchOperator
extends AbstractAuditSourceOperator {
    private static final String ES_HTTP_HOST_PREFIX = "http://";
    private static final String ES_HTTPS_HOST_PREFIX = "https://";

    @Override
    public String getType() {
        return AuditSourceType.ELASTICSEARCH.name();
    }

    @Override
    public String convertTo(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && (url.startsWith(ES_HTTP_HOST_PREFIX) || url.startsWith(ES_HTTPS_HOST_PREFIX))) {
            return url;
        }
        throw new BusinessException(String.format(ErrorCodeEnum.AUDIT_SOURCE_URL_NOT_SUPPORTED.getMessage(), url));
    }
}

