/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.audit;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.AuditSourceType;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.util.MySQLSensitiveUrlUtils;
import org.apache.inlong.manager.service.audit.AbstractAuditSourceOperator;
import org.springframework.stereotype.Service;

@Service
public class AuditSourceMysqlOperator
extends AbstractAuditSourceOperator {
    private static final String MYSQL_JDBC_PREFIX = "jdbc:mysql://";

    @Override
    public String getType() {
        return AuditSourceType.MYSQL.name();
    }

    @Override
    public String convertTo(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && url.startsWith(MYSQL_JDBC_PREFIX)) {
            return MySQLSensitiveUrlUtils.filterSensitive((String)url);
        }
        throw new BusinessException(String.format(ErrorCodeEnum.AUDIT_SOURCE_URL_NOT_SUPPORTED.getMessage(), url));
    }
}

