/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.datatype;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsvDataTypeOperator
implements DataTypeOperator {
    private static final Logger log = LoggerFactory.getLogger(CsvDataTypeOperator.class);

    @Override
    public boolean accept(DataTypeEnum type) {
        return DataTypeEnum.CSV.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage.FieldInfo> parseFields(String str, InlongStreamInfo streamInfo) throws Exception {
        List fields = CommonBeanUtils.copyListProperties((List)streamInfo.getFieldList(), BriefMQMessage.FieldInfo::new);
        try {
            char separator = '|';
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
                separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
            }
            String[] bodys = StringUtils.split((String)str, (char)separator);
            for (int i = 0; i < bodys.length; ++i) {
                if (i >= fields.size()) continue;
                ((BriefMQMessage.FieldInfo)fields.get(i)).setFieldValue(bodys[i]);
            }
        }
        catch (Exception e) {
            log.warn("parse fields failed for groupId = {}, streamId = {}", new Object[]{streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId(), e});
        }
        return fields;
    }
}

