/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateGroupCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateGroupCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        GroupOperateType operateType = form.getGroupOperateType();
        log.info("begin to execute UpdateGroupCompleteListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        InlongGroupInfo groupInfo = form.getGroupInfo();
        InlongGroupRequest groupRequest = groupInfo.genRequest();
        String operator = context.getOperator();
        List streamInfos = form.getStreamInfos();
        if (CollectionUtils.isNotEmpty((Collection)streamInfos)) {
            streamInfos.forEach(streamInfo -> this.streamService.updateWithoutCheck(streamInfo.genRequest(), operator));
        }
        switch (operateType) {
            case SUSPEND: {
                this.streamService.updateStatus(groupId, null, StreamStatus.CONFIG_OFFLINE_SUCCESSFUL.getCode(), operator);
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_OFFLINE_SUCCESSFUL.getCode(), operator);
                this.groupService.update(groupRequest, operator);
                break;
            }
            case RESTART: {
                this.streamService.updateStatus(groupId, null, StreamStatus.CONFIG_SUCCESSFUL.getCode(), operator);
                this.groupService.updateStatus(groupId, GroupStatus.CONFIG_SUCCESSFUL.getCode(), operator);
                this.groupService.update(groupRequest, operator);
                break;
            }
            case DELETE: {
                this.groupService.delete(groupId, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
        if (InlongConstants.DATASYNC_MODE.equals(groupInfo.getInlongGroupMode())) {
            this.changeSource4DataSync(groupId, operateType, operator);
        }
        log.info("success to execute UpdateGroupCompleteListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success();
    }

    private void changeSource4DataSync(String groupId, GroupOperateType operateType, String operator) {
        switch (operateType) {
            case SUSPEND: {
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_STOP.getCode(), operator);
                break;
            }
            case RESTART: {
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_NORMAL.getCode(), operator);
                break;
            }
            case DELETE: {
                this.sourceService.logicDeleteAll(groupId, null, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
    }
}

