/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.pojo.source.DataAddTaskDTO;
import org.apache.inlong.manager.pojo.source.DataAddTaskRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.file.FileDataAddTaskRequest;
import org.apache.inlong.manager.pojo.source.file.FileSource;
import org.apache.inlong.manager.pojo.source.file.FileSourceDTO;
import org.apache.inlong.manager.pojo.source.file.FileSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FileSourceOperator
extends AbstractSourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSourceOperator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "FILE".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "FILE";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        FileSourceRequest sourceRequest = (FileSourceRequest)request;
        try {
            CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
            FileSourceDTO dto = FileSourceDTO.getFromRequest((FileSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of File SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        FileSource source = new FileSource();
        if (entity == null) {
            return source;
        }
        FileSourceDTO dto = FileSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        List dataAddTaskList = this.sourceMapper.selectByTaskMapId(entity.getId());
        source.setDataAddTaskList(dataAddTaskList.stream().map(subEntity -> DataAddTaskDTO.builder().id(subEntity.getId()).taskMapId(entity.getId()).agentIp(subEntity.getAgentIp()).status(subEntity.getStatus()).build()).collect(Collectors.toList()));
        return source;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public Integer addDataAddTask(DataAddTaskRequest request, String operator) {
        FileDataAddTaskRequest sourceRequest = (FileDataAddTaskRequest)request;
        StreamSourceEntity sourceEntity = this.sourceMapper.selectById(request.getSourceId());
        try {
            List dataAddTaskList = this.sourceMapper.selectByTaskMapId(sourceEntity.getId());
            int dataAddTaskSize = CollectionUtils.isNotEmpty((Collection)dataAddTaskList) ? dataAddTaskList.size() : 0;
            FileSourceDTO dto = FileSourceDTO.getFromJson((String)sourceEntity.getExtParams());
            dto.setStartTime(sourceRequest.getStartTime());
            dto.setEndTime(sourceRequest.getEndTime());
            dto.setRetry(Boolean.valueOf(true));
            StreamSourceEntity dataAddTaskEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)sourceEntity, StreamSourceEntity::new);
            dataAddTaskEntity.setId(null);
            dataAddTaskEntity.setSourceName(sourceEntity.getSourceName() + "-" + (dataAddTaskSize + 1));
            dataAddTaskEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            dataAddTaskEntity.setTaskMapId(sourceEntity.getId());
            return this.sourceMapper.insert(dataAddTaskEntity);
        }
        catch (Exception e) {
            LOGGER.error("serialize extParams of File SourceDTO failure: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of File SourceDTO failure: %s", e.getMessage()));
        }
    }
}

