/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.common.pojo.sort.mq.PulsarClusterConfig;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.ClusterConfigEntity;
import org.apache.inlong.manager.dao.mapper.ClusterConfigEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.service.cluster.ClusterConfigService;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterConfigServiceImpl
implements ClusterConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigServiceImpl.class);
    @Autowired
    private ClusterConfigEntityMapper clusterConfigEntityMapper;
    @Autowired
    private InlongClusterService clusterService;

    @Override
    public boolean refresh(String clusterTag, String operator) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List<ClusterInfo> clusterInfos = this.clusterService.listByTagAndType(clusterTag, "PULSAR");
            ArrayList<PulsarClusterConfig> list = new ArrayList<PulsarClusterConfig>();
            ClusterConfigEntity existEntity = this.clusterConfigEntityMapper.selectByClusterTag(clusterTag);
            for (ClusterInfo clusterInfo : clusterInfos) {
                PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)clusterInfo;
                PulsarClusterConfig pulsarClusterConfig = (PulsarClusterConfig)CommonBeanUtils.copyProperties((Object)pulsarCluster, PulsarClusterConfig::new);
                pulsarClusterConfig.setVersion(pulsarCluster.getVersion());
                pulsarClusterConfig.setClusterName(pulsarCluster.getName());
                pulsarClusterConfig.setServiceUrl(pulsarCluster.getUrl());
                list.add(pulsarClusterConfig);
            }
            ClusterConfigEntity clusterConfigEntity = existEntity == null ? new ClusterConfigEntity() : existEntity;
            clusterConfigEntity.setConfigParams(objectMapper.writeValueAsString(list));
            clusterConfigEntity.setClusterTag(clusterTag);
            clusterConfigEntity.setClusterType("PULSAR");
            clusterConfigEntity.setModifier(operator);
            if (existEntity == null) {
                clusterConfigEntity.setCreator(operator);
                this.clusterConfigEntityMapper.insert(clusterConfigEntity);
            } else {
                this.clusterConfigEntityMapper.updateByIdSelective(clusterConfigEntity);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("push cluster config failed for cluster Tag=%s", clusterTag);
            LOGGER.error(errMsg, (Throwable)e);
            throw new WorkflowListenerException(errMsg);
        }
        return true;
    }
}

