/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ModuleType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.entity.ModuleConfigEntity;
import org.apache.inlong.manager.dao.entity.PackageConfigEntity;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.ModuleConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.PackageConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeInstallOperator;
import org.apache.inlong.manager.service.cmd.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgentClusterNodeInstallOperator
implements InlongClusterNodeInstallOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentClusterNodeInstallOperator.class);
    public static final String INSTALLER_CONF_PATH = "/conf/installer.properties";
    public static final String INSTALLER_START_CMD = "/bin/installer.sh start";
    public static final String AGENT_MANAGER_AUTH_SECRET_ID = "agent.manager.auth.secretId";
    public static final String AGENT_MANAGER_AUTH_SECRET_KEY = "agent.manager.auth.secretKey";
    public static final String AGENT_MANAGER_ADDR = "agent.manager.addr";
    public static final String AGENT_CLUSTER_NAME = "agent.cluster.name";
    public static final String AGENT_CLUSTER_TAG = "agent.cluster.tag";
    public static final String AGENT_LOCAL_IP = "agent.local.ip";
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private CommandExecutor commandExecutor;
    @Autowired
    private ModuleConfigEntityMapper moduleConfigEntityMapper;
    @Autowired
    private PackageConfigEntityMapper packageConfigEntityMapper;
    @Autowired
    private UserEntityMapper userEntityMapper;
    @Value(value="${agent.install.path:inlong/inlong-installer/}")
    private String agentInstallPath;
    @Value(value="${manager.url:127.0.0.1:8083}")
    private String managerUrl;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterNodeType().equals(clusterType);
    }

    @Override
    public String getClusterNodeType() {
        return "AGENT";
    }

    @Override
    public boolean install(ClusterNodeRequest clusterNodeRequest, String operator) {
        LOGGER.info("begin to insert agent inlong cluster node={}", (Object)clusterNodeRequest);
        try {
            InlongClusterEntity clusterEntity = this.clusterEntityMapper.selectById(clusterNodeRequest.getParentId());
            AgentClusterNodeRequest request = (AgentClusterNodeRequest)clusterNodeRequest;
            this.commandExecutor.mkdir(request, this.agentInstallPath);
            String downLoadUrl = this.getInstallerDownLoadUrl(request);
            String fileName = downLoadUrl.substring(downLoadUrl.lastIndexOf(47) + 1);
            this.commandExecutor.downLoadPackage(request, this.agentInstallPath, downLoadUrl);
            this.commandExecutor.tarPackage(request, fileName, this.agentInstallPath);
            String confFile = this.agentInstallPath + INSTALLER_CONF_PATH;
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put(AGENT_LOCAL_IP, request.getIp());
            configMap.put(AGENT_MANAGER_ADDR, this.managerUrl);
            UserEntity userInfo = this.userEntityMapper.selectByName(operator);
            Preconditions.expectNotNull((Object)userInfo, (String)"User doesn't exist");
            String secretKey = new String(AESUtils.decryptAsString((String)userInfo.getSecretKey(), (Integer)userInfo.getEncryptVersion()));
            configMap.put(AGENT_MANAGER_AUTH_SECRET_ID, operator);
            configMap.put(AGENT_MANAGER_AUTH_SECRET_KEY, secretKey);
            configMap.put(AGENT_CLUSTER_TAG, clusterEntity.getClusterTags());
            configMap.put(AGENT_CLUSTER_NAME, clusterEntity.getName());
            this.commandExecutor.modifyConfig(request, configMap, confFile);
            String startCmd = this.agentInstallPath + INSTALLER_START_CMD;
            this.commandExecutor.execRemote(request, startCmd);
        }
        catch (Exception e) {
            String errMsg = String.format("install installer failed for ip=%s", clusterNodeRequest.getIp());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
        LOGGER.info("success to insert agent inlong cluster node={}", (Object)clusterNodeRequest);
        return true;
    }

    @Override
    public boolean unload(InlongClusterNodeEntity clusterNodeEntity, String operator) {
        InlongClusterEntity clusterEntity = this.clusterEntityMapper.selectById(clusterNodeEntity.getParentId());
        return true;
    }

    private String getInstallerDownLoadUrl(AgentClusterNodeRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getModuleIdList())) {
            throw new BusinessException(String.format("install failed when module id list is null for ip=%s, type=%s", request.getIp(), request.getType()));
        }
        for (Integer moduleId : request.getModuleIdList()) {
            ModuleConfigEntity moduleConfigEntity = this.moduleConfigEntityMapper.selectByPrimaryKey(moduleId);
            if (!Objects.equals(moduleConfigEntity.getType(), ModuleType.INSTALLER.name())) continue;
            PackageConfigEntity packageConfigEntity = this.packageConfigEntityMapper.selectByPrimaryKey(moduleConfigEntity.getPackageId());
            return packageConfigEntity.getDownloadUrl();
        }
        throw new BusinessException(String.format("can't get installer download url for ip=%s, type=%s", request.getIp(), request.getType()));
    }
}

