/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.message;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.apache.inlong.manager.service.datatype.DataTypeOperatorFactory;
import org.apache.inlong.manager.service.message.DeserializeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawMsgDeserializeOperator
implements DeserializeOperator {
    private static final Logger log = LoggerFactory.getLogger(RawMsgDeserializeOperator.class);
    @Autowired
    public DataTypeOperatorFactory dataTypeOperatorFactory;

    @Override
    public boolean accept(MessageWrapType type) {
        return MessageWrapType.RAW.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage> decodeMsg(InlongStreamInfo streamInfo, List<BriefMQMessage> briefMQMessages, byte[] msgBytes, Map<String, String> headers, int index, QueryMessageRequest request) {
        String groupId = headers.get("groupId");
        String streamId = headers.get("streamId");
        long msgTime = Long.parseLong(headers.getOrDefault("msgTime", "0"));
        String body = new String(msgBytes, Charset.forName(streamInfo.getDataEncoding()));
        try {
            DataTypeOperator dataTypeOperator = this.dataTypeOperatorFactory.getInstance(DataTypeEnum.forType((String)streamInfo.getDataType()));
            List<BriefMQMessage.FieldInfo> fieldList = dataTypeOperator.parseFields(body, streamInfo);
            if (this.checkIfFilter(request, fieldList).booleanValue()) {
                return briefMQMessages;
            }
            BriefMQMessage briefMQMessage = BriefMQMessage.builder().id(Integer.valueOf(index)).inlongGroupId(groupId).inlongStreamId(streamId).dt(Long.valueOf(msgTime)).clientIp(headers.get("clientIp")).headers(headers).body(body).fieldList(fieldList).build();
            briefMQMessages.addAll(Collections.singletonList(briefMQMessage));
            return briefMQMessages;
        }
        catch (Exception e) {
            String errMsg = String.format("decode msg failed for groupId=%s, streamId=%s", groupId, streamId);
            log.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

