/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.es;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchCreateIndexResponse;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchIndexMappingInfo;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

@Component
public class ElasticsearchApi {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchApi.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String MAPPINGS_KEY = "mappings";
    private static final String FIELD_KEY = "properties";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_FORMAT = "format";
    private static final String CONTENT_TYPE_VALUE = "application/json;charset=UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchApi.class);
    @Autowired
    private ElasticsearchConfig esConfig;

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        if (this.esConfig.getAuthEnable().booleanValue() && StringUtils.isNotEmpty((CharSequence)this.esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.esConfig.getPassword())) {
            String tokenStr = this.esConfig.getUsername() + ":" + this.esConfig.getPassword();
            String token = String.valueOf(new BASE64Encoder().encode(tokenStr.getBytes(StandardCharsets.UTF_8)));
            headers.add("Authorization", "Basic " + token);
        }
        return headers;
    }

    public JsonObject search(String indexName, JsonObject request) throws Exception {
        LOG.info("get es search es index:{} request:{}", (Object)indexName, (Object)request.toString());
        String url = this.esConfig.getOneHttpUrl() + "/" + indexName + "/_search";
        return (JsonObject)HttpUtils.request((RestTemplate)this.esConfig.getRestClient(), (String)url, (HttpMethod)HttpMethod.POST, (String)request.toString(), (HttpHeaders)this.getHttpHeaders(), JsonObject.class);
    }

    public boolean indexExists(String indexName) throws Exception {
        String url = this.esConfig.getOneHttpUrl() + "/" + indexName;
        try {
            return HttpUtils.headRequest((RestTemplate)this.esConfig.getRestClient(), (String)url, null, (HttpHeaders)this.getHttpHeaders());
        }
        catch (HttpClientErrorException.NotFound e) {
            return false;
        }
    }

    public boolean ping() throws Exception {
        String[] urls = this.esConfig.getHttpUrls("/");
        boolean result = true;
        for (String url : urls) {
            result &= HttpUtils.headRequest((RestTemplate)this.esConfig.getRestClient(), (String)url, null, (HttpHeaders)this.getHttpHeaders());
        }
        return result;
    }

    public void createIndex(String indexName) throws Exception {
        String url = this.esConfig.getOneHttpUrl() + "/" + indexName;
        ElasticsearchCreateIndexResponse response = (ElasticsearchCreateIndexResponse)HttpUtils.request((RestTemplate)this.esConfig.getRestClient(), (String)url, (HttpMethod)HttpMethod.PUT, null, (HttpHeaders)this.getHttpHeaders(), ElasticsearchCreateIndexResponse.class);
        LOG.info("create es index:{} result: {}", (Object)indexName, (Object)response.getAcknowledged());
    }

    private ElasticsearchIndexMappingInfo getMappingInfo(List<ElasticsearchFieldInfo> fieldsInfo) {
        HashMap fields = Maps.newHashMap();
        for (ElasticsearchFieldInfo field : fieldsInfo) {
            ElasticsearchIndexMappingInfo.IndexField indexField = new ElasticsearchIndexMappingInfo.IndexField();
            fields.put(field.getFieldName(), indexField);
            indexField.setType(field.getFieldType());
            if (field.getFieldType().equals("text")) {
                if (StringUtils.isNotEmpty((CharSequence)field.getAnalyzer())) {
                    indexField.setAnalyzer(field.getAnalyzer());
                }
                if (!StringUtils.isNotEmpty((CharSequence)field.getSearchAnalyzer())) continue;
                indexField.setSearchAnalyzer(field.getSearchAnalyzer());
                continue;
            }
            if (field.getFieldType().equals("date")) {
                if (!StringUtils.isNotEmpty((CharSequence)field.getFieldFormat())) continue;
                indexField.setFormat(field.getFieldFormat());
                continue;
            }
            if (!field.getFieldType().equals("scaled_float") || !StringUtils.isNotEmpty((CharSequence)field.getScalingFactor())) continue;
            indexField.setScalingFactor(field.getScalingFactor());
        }
        return ElasticsearchIndexMappingInfo.builder().mappings(ElasticsearchIndexMappingInfo.IndexMappings.builder().properties((Map)fields).build()).build();
    }

    public void createIndexAndMapping(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws Exception {
        ElasticsearchIndexMappingInfo mappingInfo = this.getMappingInfo(fieldInfos);
        String url = this.esConfig.getOneHttpUrl() + "/" + indexName;
        ElasticsearchCreateIndexResponse response = (ElasticsearchCreateIndexResponse)HttpUtils.request((RestTemplate)this.esConfig.getRestClient(), (String)url, (HttpMethod)HttpMethod.PUT, (String)GSON.toJsonTree((Object)mappingInfo).getAsJsonObject().toString(), (HttpHeaders)this.getHttpHeaders(), ElasticsearchCreateIndexResponse.class);
        LOG.info("create {}:{}", (Object)indexName, (Object)response.getIndex());
    }

    public Map<String, ElasticsearchFieldInfo> getMappingMap(String indexName) throws Exception {
        String url = this.esConfig.getOneHttpUrl() + "/" + indexName + "/_mapping";
        JsonObject result = (JsonObject)HttpUtils.request((RestTemplate)this.esConfig.getRestClient(), (String)url, (HttpMethod)HttpMethod.GET, null, (HttpHeaders)this.getHttpHeaders(), JsonObject.class);
        JsonObject mappings = result.getAsJsonObject(indexName);
        JsonObject properties = null;
        JsonObject fields = null;
        HashMap fieldInfos = Maps.newHashMap();
        if (ObjectUtils.isNotEmpty((Object)mappings)) {
            properties = mappings.getAsJsonObject(MAPPINGS_KEY);
        }
        if (ObjectUtils.isNotEmpty(properties)) {
            fields = properties.getAsJsonObject(FIELD_KEY);
        }
        if (ObjectUtils.isNotEmpty(fields)) {
            for (String key : fields.keySet()) {
                JsonObject field = fields.getAsJsonObject(key);
                if (!StringUtils.isNotEmpty((CharSequence)key) || !ObjectUtils.isNotEmpty((Object)field)) continue;
                ElasticsearchFieldInfo fieldInfo = new ElasticsearchFieldInfo();
                if (ObjectUtils.isNotEmpty((Object)field.get(FIELD_TYPE))) {
                    fieldInfo.setFieldType(field.get(FIELD_TYPE).getAsString());
                }
                if (ObjectUtils.isNotEmpty((Object)field.get(FIELD_FORMAT))) {
                    fieldInfo.setFieldFormat(field.get(FIELD_FORMAT).getAsString());
                }
                fieldInfo.setFieldName(key);
                fieldInfos.put(key, fieldInfo);
            }
        }
        return fieldInfos;
    }

    public void addFields(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws Exception {
        ElasticsearchIndexMappingInfo mappingInfo = this.getMappingInfo(fieldInfos);
        if (ObjectUtils.isNotEmpty((Object)mappingInfo) && !mappingInfo.getMappings().getProperties().isEmpty()) {
            String url = this.esConfig.getOneHttpUrl() + "/" + indexName + "/_mapping";
            HttpUtils.request((RestTemplate)this.esConfig.getRestClient(), (String)url, (HttpMethod)HttpMethod.PUT, (String)GSON.toJsonTree((Object)mappingInfo.getMappings()).getAsJsonObject().toString(), (HttpHeaders)this.getHttpHeaders(), Object.class);
        }
    }

    public void addNotExistFields(String indexName, List<ElasticsearchFieldInfo> fieldInfos) throws Exception {
        ArrayList<ElasticsearchFieldInfo> notExistFieldInfos = new ArrayList<ElasticsearchFieldInfo>();
        Map<String, ElasticsearchFieldInfo> mappings = this.getMappingMap(indexName);
        for (ElasticsearchFieldInfo fieldInfo : fieldInfos) {
            if (mappings.containsKey(fieldInfo.getFieldName())) continue;
            notExistFieldInfos.add(fieldInfo);
        }
        if (!notExistFieldInfos.isEmpty()) {
            this.addFields(indexName, notExistFieldInfos);
        }
    }

    public void setEsConfig(ElasticsearchConfig config) {
        this.esConfig = config;
    }
}

