/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.cls;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.common.pojo.sort.dataflow.field.FieldConfig;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.sink.ClsSinkConfig;
import org.apache.inlong.common.pojo.sort.dataflow.sink.SinkConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.cls.ClsDataNodeDTO;
import org.apache.inlong.manager.pojo.node.cls.ClsDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.cls.ClsSink;
import org.apache.inlong.manager.pojo.sink.cls.ClsSinkDTO;
import org.apache.inlong.manager.pojo.sink.cls.ClsSinkRequest;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClsSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClsSinkOperator.class);
    private static final String KEY_FIELDS = "fieldNames";
    private static final String SECRET_KEY = "secretKey";
    private static final String SECRET_ID = "secretId";
    private static final String END_POINT = "endpoint";
    private static final String TOPIC_ID = "topicId";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeEntityMapper;

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        ClsSinkRequest sinkRequest = (ClsSinkRequest)request;
        try {
            ClsSinkDTO dto = ClsSinkDTO.getFromRequest((ClsSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            InlongStreamEntity stream = this.inlongStreamEntityMapper.selectByIdentifier(request.getInlongGroupId(), request.getInlongStreamId());
            dto.setSeparator(String.valueOf((char)Integer.parseInt(stream.getDataSeparator())));
            InlongStreamExtParam streamExt = (InlongStreamExtParam)JsonUtils.parseObject((String)stream.getExtParams(), InlongStreamExtParam.class);
            dto.setFieldOffset(streamExt.getExtendedFieldSize());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Doris SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    protected String getSinkType() {
        return "CLS";
    }

    @Override
    public Boolean accept(String sinkType) {
        return "CLS".equals(sinkType);
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        ClsSink sink = new ClsSink();
        if (entity == null) {
            return sink;
        }
        ClsSinkDTO dto = ClsSinkDTO.getFromJson((String)entity.getExtParams());
        DataNodeEntity dataNodeEntity = this.dataNodeEntityMapper.selectByUniqueKey(entity.getDataNodeName(), "CLS");
        ClsDataNodeDTO clsDataNodeDTO = (ClsDataNodeDTO)JsonUtils.parseObject((String)dataNodeEntity.getExtParams(), ClsDataNodeDTO.class);
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)clsDataNodeDTO, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = this.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }

    @Override
    public Map<String, String> parse2IdParams(StreamSinkEntity streamSink, List<String> fields, DataNodeInfo dataNodeInfo) {
        Map<String, String> params = super.parse2IdParams(streamSink, fields, dataNodeInfo);
        ClsSinkDTO clsSinkDTO = (ClsSinkDTO)JsonUtils.parseObject((String)streamSink.getExtParams(), ClsSinkDTO.class);
        params.computeIfAbsent(TOPIC_ID, k -> clsSinkDTO.getTopicId());
        ClsDataNodeInfo clsDataNodeInfo = (ClsDataNodeInfo)dataNodeInfo;
        params.computeIfAbsent(SECRET_ID, k -> clsDataNodeInfo.getSendSecretId());
        params.computeIfAbsent(SECRET_KEY, k -> clsDataNodeInfo.getSendSecretKey());
        params.computeIfAbsent(END_POINT, k -> clsDataNodeInfo.getEndpoint());
        StringBuilder fieldNames = new StringBuilder();
        for (String field : fields) {
            fieldNames.append(field).append(" ");
        }
        params.computeIfAbsent(KEY_FIELDS, k -> fieldNames.toString());
        return params;
    }

    @Override
    public SinkConfig getSinkConfig(InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, StreamSink sink) {
        ClsSink clsSink = (ClsSink)sink;
        ClsSinkConfig sinkConfig = (ClsSinkConfig)CommonBeanUtils.copyProperties((Object)clsSink, ClsSinkConfig::new);
        sinkConfig.setSeparator(String.valueOf((char)Integer.parseInt(streamInfo.getDataSeparator())));
        sinkConfig.setFieldOffset(streamInfo.getExtendedFieldSize());
        sinkConfig.setContentOffset(Integer.valueOf(0));
        List fields = this.sinkFieldMapper.selectBySinkId(sink.getId()).stream().map(v -> {
            FieldConfig fieldConfig = new FieldConfig();
            FormatInfo formatInfo = FieldInfoUtils.convertFieldFormat((String)v.getFieldType().toLowerCase());
            fieldConfig.setName(v.getFieldName());
            fieldConfig.setFormatInfo(formatInfo);
            return fieldConfig;
        }).collect(Collectors.toList());
        sinkConfig.setFieldConfigs(fields);
        return sinkConfig;
    }
}

