/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import java.util.Date;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractClusterOperator
implements InlongClusterOperator {
    @Autowired
    protected InlongClusterEntityMapper clusterMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(InlongClusterRequest request, String operator) {
        InlongClusterEntity entity = (InlongClusterEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterEntity::new);
        this.setTargetEntity(request, entity);
        entity.setCreator(operator);
        entity.setCreateTime(new Date());
        entity.setIsDeleted(GlobalConstants.UN_DELETED);
        this.clusterMapper.insert(entity);
        return entity.getId();
    }

    protected abstract void setTargetEntity(InlongClusterRequest var1, InlongClusterEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(InlongClusterRequest request, String operator) {
        InlongClusterEntity entity = (InlongClusterEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterEntity::new);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        this.clusterMapper.updateByIdSelective(entity);
    }
}

