/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterRequest;
import org.apache.inlong.manager.common.pojo.cluster.tube.TubeClusterInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.apache.inlong.manager.service.group.InlongNoneMqOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TubeClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongNoneMqOperator.class);

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "TUBE";
    }

    @Override
    protected void setTargetEntity(InlongClusterRequest request, InlongClusterEntity targetEntity) {
        LOGGER.info("do nothing for tube cluster in set target entity");
    }

    @Override
    public InlongClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        return (InlongClusterInfo)CommonBeanUtils.copyProperties((Object)entity, TubeClusterInfo::new);
    }
}

