/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.inlong.manager.common.enums.DataNodeType;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.common.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.common.pojo.node.DataNodeResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.service.core.DataNodeService;
import org.apache.inlong.manager.service.resource.hive.HiveJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private DataNodeEntityMapper dataNodeMapper;

    @Override
    public Integer save(DataNodeRequest request, String operator) {
        Preconditions.checkNotNull((Object)request, (String)"data node info cannot be empty");
        String name = request.getName();
        String type = request.getType();
        Preconditions.checkNotEmpty((String)name, (String)"data node name cannot be empty");
        Preconditions.checkNotEmpty((String)type, (String)"data node type cannot be empty");
        DataNodeEntity exist = this.dataNodeMapper.selectByNameAndType(name, type);
        if (exist != null) {
            String errMsg = String.format("data node already exist for name=%s type=%s)", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeEntity entity = (DataNodeEntity)CommonBeanUtils.copyProperties((Object)request, DataNodeEntity::new);
        entity.setCreator(operator);
        entity.setCreateTime(new Date());
        entity.setIsDeleted(GlobalConstants.UN_DELETED);
        this.dataNodeMapper.insert(entity);
        LOGGER.debug("success to save data node={}", (Object)request);
        return entity.getId();
    }

    @Override
    public DataNodeResponse get(Integer id) {
        Preconditions.checkNotNull((Object)id, (String)"data node id cannot be empty");
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("data node not found by id={}", (Object)id);
            throw new BusinessException("data node not found");
        }
        DataNodeResponse response = (DataNodeResponse)CommonBeanUtils.copyProperties((Object)entity, DataNodeResponse::new);
        LOGGER.debug("success to get data node info by id={}", (Object)id);
        return response;
    }

    @Override
    public PageInfo<DataNodeResponse> list(DataNodePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dataNodeMapper.selectByCondition(request);
        List responseList = CommonBeanUtils.copyListProperties((List)entityPage, DataNodeResponse::new);
        PageInfo page = new PageInfo(responseList);
        page.setTotal((long)responseList.size());
        LOGGER.debug("success to list data node by {}", (Object)request);
        return page;
    }

    @Override
    public Boolean update(DataNodeRequest request, String operator) {
        Preconditions.checkNotNull((Object)request, (String)"data node info cannot be empty");
        String name = request.getName();
        String type = request.getType();
        Preconditions.checkNotEmpty((String)name, (String)"data node name cannot be empty");
        Preconditions.checkNotEmpty((String)type, (String)"data node type cannot be empty");
        Integer id = request.getId();
        Preconditions.checkNotNull((Object)id, (String)"data node id is empty");
        DataNodeEntity exist = this.dataNodeMapper.selectByNameAndType(name, type);
        if (exist != null && !Objects.equals(id, exist.getId())) {
            String errMsg = String.format("data node already exist for name=%s type=%s", name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("data node not found by id={}", (Object)id);
            throw new BusinessException(String.format("data node not found by id=%s", id));
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)entity, (boolean)true);
        entity.setModifier(operator);
        this.dataNodeMapper.updateById(entity);
        LOGGER.info("success to update data node={}", (Object)request);
        return true;
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        Preconditions.checkNotNull((Object)id, (String)"data node id cannot be empty");
        DataNodeEntity entity = this.dataNodeMapper.selectById(id);
        if (entity == null || entity.getIsDeleted() > GlobalConstants.UN_DELETED) {
            LOGGER.error("data node not found or was already deleted for id={}", (Object)id);
            return false;
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        this.dataNodeMapper.updateById(entity);
        LOGGER.info("success to delete data node by id={}", (Object)id);
        return true;
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        LOGGER.info("begin test connection for: {}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"Connection request cannot be empty");
        String type = request.getType();
        Preconditions.checkNotNull((Object)type, (String)"Connection type cannot be empty");
        Boolean result = false;
        if (DataNodeType.HIVE.toString().equals(type)) {
            result = this.testHiveConnection(request);
        }
        LOGGER.info("connection [{}] for: {}", (Object)(result != false ? "success" : "failed"), (Object)request);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean testHiveConnection(DataNodeRequest request) {
        String url = request.getUrl();
        Preconditions.checkNotNull((Object)url, (String)"connection url cannot be empty");
        try (Connection ignored = HiveJdbcUtils.getConnection(url, request.getUsername(), request.getToken());){
            LOGGER.info("hive connection not null - connection success");
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("hive connection failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

