/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.SinkBriefResponse;
import org.apache.inlong.manager.common.pojo.sink.SinkRequest;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.stream.FullStreamRequest;
import org.apache.inlong.manager.common.pojo.stream.FullStreamResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamApproveRequest;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamListResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InlongStreamServiceImpl
implements InlongStreamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongStreamServiceImpl.class);
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private StreamSinkService sinkService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to save inlong stream info={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"inlong stream info is empty");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, streamId);
        if (count >= 1) {
            LOGGER.error("inlong stream id [{}] has already exists", (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE);
        }
        if (StringUtils.isEmpty((CharSequence)request.getMqResource())) {
            request.setMqResource(streamId);
        }
        InlongStreamEntity streamEntity = (InlongStreamEntity)CommonBeanUtils.copyProperties((Object)request, InlongStreamEntity::new);
        streamEntity.setStatus(StreamStatus.NEW.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setCreateTime(new Date());
        this.streamMapper.insertSelective(streamEntity);
        this.saveField(groupId, streamId, request.getFieldList());
        if (CollectionUtils.isNotEmpty((Collection)request.getExtList())) {
            this.saveOrUpdateExt(groupId, streamId, request.getExtList());
        }
        LOGGER.info("success to save inlong stream info for groupId={}", (Object)groupId);
        return streamEntity.getId();
    }

    @Override
    public InlongStreamInfo get(String groupId, String streamId) {
        LOGGER.debug("begin to get inlong stream by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
        streamInfo.setFieldList(streamFields);
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, streamId);
        List exts = CommonBeanUtils.copyListProperties((List)extEntities, InlongStreamExtInfo::new);
        streamInfo.setExtList(exts);
        LOGGER.info("success to get inlong stream for groupId={}", (Object)groupId);
        return streamInfo;
    }

    @Override
    public List<InlongStreamInfo> list(String groupId) {
        LOGGER.debug("begin to list inlong streams by groupId={}", (Object)groupId);
        List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupId);
        List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
        List<StreamField> streamFields = this.getStreamFields(groupId, null);
        Map streamFieldMap = streamFields.stream().collect(Collectors.groupingBy(StreamField::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List extEntities = this.streamExtMapper.selectByRelatedId(groupId, null);
        Map extInfoMap = extEntities.stream().map(extEntity -> (InlongStreamExtInfo)CommonBeanUtils.copyProperties((Object)extEntity, InlongStreamExtInfo::new)).collect(Collectors.groupingBy(InlongStreamExtInfo::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        streamList.forEach(streamInfo -> {
            String streamId = streamInfo.getInlongStreamId();
            List fieldInfos = (List)streamFieldMap.get(streamId);
            streamInfo.setFieldList(fieldInfos);
            List extInfos = (List)extInfoMap.get(streamId);
            streamInfo.setExtList(extInfos);
        });
        return streamList;
    }

    @Override
    public Boolean exist(String groupId, String streamId) {
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        return streamEntity != null;
    }

    private List<StreamField> getStreamFields(String groupId, String streamId) {
        List fieldEntityList = this.streamFieldMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)fieldEntityList)) {
            return Collections.emptyList();
        }
        return CommonBeanUtils.copyListProperties((List)fieldEntityList, StreamField::new);
    }

    @Override
    public PageInfo<InlongStreamListResponse> listByCondition(InlongStreamPageRequest request) {
        LOGGER.debug("begin to list inlong stream page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.streamMapper.selectByCondition(request);
        List streamList = CommonBeanUtils.copyListProperties((List)entityPage, InlongStreamListResponse::new);
        String groupId = request.getInlongGroupId();
        String sinkType = request.getSinkType();
        if (StringUtils.isNotEmpty((CharSequence)sinkType)) {
            List<String> streamIdList = streamList.stream().map(InlongStreamListResponse::getInlongStreamId).distinct().collect(Collectors.toList());
            List<String> resultList = this.sinkService.getExistsStreamIdList(groupId, sinkType, streamIdList);
            streamList.removeIf(entity -> resultList.contains(entity.getInlongStreamId()));
        }
        if (request.getNeedSinkList() == 1) {
            streamList.forEach(stream -> {
                String streamId = stream.getInlongStreamId();
                List<String> sinkTypeList = this.sinkService.getSinkTypeList(groupId, streamId);
                stream.setSinkTypeList(sinkTypeList);
            });
        }
        PageInfo page = new PageInfo(streamList);
        page.setTotal((long)streamList.size());
        LOGGER.debug("success to list inlong stream info for groupId={}", (Object)groupId);
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(InlongStreamRequest request, String operator) {
        LOGGER.debug("begin to update inlong stream info={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"inlong stream request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        InlongGroupEntity inlongGroupEntity = this.checkGroupStatusIsTemp(groupId);
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        this.checkCanUpdate(inlongGroupEntity.getStatus(), streamEntity, request);
        CommonBeanUtils.copyProperties((Object)request, (Object)streamEntity, (boolean)true);
        streamEntity.setModifier(operator);
        this.streamMapper.updateByIdentifierSelective(streamEntity);
        this.updateField(groupId, streamId, request.getFieldList());
        List extInfos = request.getExtList();
        this.saveOrUpdateExt(groupId, streamId, extInfos);
        LOGGER.info("success to update inlong stream for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String groupId, String streamId, String operator) {
        LOGGER.debug("begin to delete inlong stream, groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        Preconditions.checkNotNull((Object)streamId, (String)ErrorCodeEnum.STREAM_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        InlongStreamEntity entity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (entity == null) {
            LOGGER.error("inlong stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(ErrorCodeEnum.STREAM_NOT_FOUND);
        }
        Integer sourceCount = this.sourceService.getCount(groupId, streamId);
        if (sourceCount > 0) {
            LOGGER.error("inlong stream has undeleted sources, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SOURCE);
        }
        int sinkCount = this.sinkService.getCount(groupId, streamId);
        if (sinkCount > 0) {
            LOGGER.error("inlong stream has undeleted sinks, delete failed");
            throw new BusinessException(ErrorCodeEnum.STREAM_DELETE_HAS_SINK);
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        this.streamMapper.updateByPrimaryKey(entity);
        LOGGER.debug("begin to delete inlong stream field, streamId={}", (Object)streamId);
        this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
        this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
        LOGGER.info("success to delete inlong stream, ext property and fields for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean logicDeleteAll(String groupId, String operator) {
        LOGGER.debug("begin to delete all inlong stream by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        this.checkGroupStatusIsTemp(groupId);
        List entityList = this.streamMapper.selectByGroupId(groupId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            LOGGER.info("inlong stream not found by groupId={}", (Object)groupId);
            return true;
        }
        for (InlongStreamEntity entity : entityList) {
            entity.setIsDeleted(Integer.valueOf(1));
            entity.setModifier(operator);
            this.streamMapper.updateByIdentifierSelective(entity);
            String streamId = entity.getInlongStreamId();
            this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
            this.streamExtMapper.logicDeleteAllByRelatedId(groupId, streamId);
            this.sourceService.logicDeleteAll(groupId, streamId, operator);
            this.sinkService.logicDeleteAll(groupId, streamId, operator);
        }
        LOGGER.info("success to delete all inlong stream, ext property and fields by groupId={}", (Object)groupId);
        return true;
    }

    @Override
    public List<StreamBriefResponse> getBriefList(String groupId) {
        LOGGER.debug("begin to get inlong stream brief list by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        List entityList = this.streamMapper.selectByGroupId(groupId);
        List briefInfoList = CommonBeanUtils.copyListProperties((List)entityList, StreamBriefResponse::new);
        for (StreamBriefResponse briefInfo : briefInfoList) {
            String streamId = briefInfo.getInlongStreamId();
            List<SinkBriefResponse> sinkList = this.sinkService.listBrief(groupId, streamId);
            briefInfo.setSinkList(sinkList);
        }
        LOGGER.info("success to get inlong stream brief list for groupId={}", (Object)groupId);
        return briefInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean saveAll(FullStreamRequest fullStreamRequest, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to save all stream page info: {}", (Object)fullStreamRequest);
        }
        Preconditions.checkNotNull((Object)fullStreamRequest, (String)"fullStreamRequest is empty");
        InlongStreamRequest streamRequest = fullStreamRequest.getStreamInfo();
        Preconditions.checkNotNull((Object)streamRequest, (String)"inlong stream info is empty");
        this.save(streamRequest, operator);
        if (CollectionUtils.isNotEmpty((Collection)fullStreamRequest.getSourceInfo())) {
            for (SourceRequest source : fullStreamRequest.getSourceInfo()) {
                this.sourceService.save(source, operator);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fullStreamRequest.getSinkInfo())) {
            for (SinkRequest sinkInfo : fullStreamRequest.getSinkInfo()) {
                this.sinkService.save(sinkInfo, operator);
            }
        }
        LOGGER.info("success to save all stream page info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean batchSaveAll(List<FullStreamRequest> fullStreamRequestList, String operator) {
        if (CollectionUtils.isEmpty(fullStreamRequestList)) {
            return true;
        }
        LOGGER.info("begin to batch save all stream page info, batch size={}", (Object)fullStreamRequestList.size());
        InlongStreamRequest firstStream = fullStreamRequestList.get(0).getStreamInfo();
        Preconditions.checkNotNull((Object)firstStream, (String)"inlong stream info is empty");
        String groupId = firstStream.getInlongGroupId();
        this.checkGroupStatusIsTemp(groupId);
        this.streamMapper.deleteAllByGroupId(groupId);
        for (FullStreamRequest pageInfo : fullStreamRequestList) {
            InlongStreamRequest streamInfo = pageInfo.getStreamInfo();
            String streamId = streamInfo.getInlongStreamId();
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.streamExtMapper.deleteAllByRelatedId(groupId, streamId);
            this.sourceService.deleteAll(groupId, streamId, operator);
            this.sinkService.deleteAll(groupId, streamId, operator);
            this.saveAll(pageInfo, operator);
        }
        LOGGER.info("success to batch save all stream page info");
        return true;
    }

    @Override
    public PageInfo<FullStreamResponse> listAllWithGroupId(InlongStreamPageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list full inlong stream page by {}", (Object)request);
        }
        Preconditions.checkNotNull((Object)request, (String)"request is empty");
        Preconditions.checkNotNull((Object)request.getInlongGroupId(), (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        String groupId = request.getInlongGroupId();
        InlongGroupEntity inlongGroupEntity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)inlongGroupEntity, (String)("inlong group not found by groupId=" + groupId));
        String inCharges = inlongGroupEntity.getInCharges();
        request.setInCharges(inCharges);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.streamMapper.selectByCondition(request);
        List streamInfoList = CommonBeanUtils.copyListProperties((List)page, InlongStreamInfo::new);
        ArrayList<FullStreamResponse> responseList = new ArrayList<FullStreamResponse>(streamInfoList.size());
        for (InlongStreamInfo streamInfo : streamInfoList) {
            String streamId = streamInfo.getInlongStreamId();
            List<StreamField> streamFields = this.getStreamFields(groupId, streamId);
            streamInfo.setFieldList(streamFields);
            List streamExtInfos = CommonBeanUtils.copyListProperties((List)this.streamExtMapper.selectByRelatedId(groupId, streamId), InlongStreamExtInfo::new);
            streamInfo.setExtList(streamExtInfos);
            FullStreamResponse pageInfo = new FullStreamResponse();
            pageInfo.setStreamInfo(streamInfo);
            List<StreamSource> sourceList = this.sourceService.listSource(groupId, streamId);
            pageInfo.setSourceInfo(sourceList);
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            pageInfo.setSinkInfo(sinkList);
            responseList.add(pageInfo);
        }
        PageInfo pageInfo = new PageInfo(responseList);
        pageInfo.setTotal(pageInfo.getTotal());
        LOGGER.debug("success to list full inlong stream info");
        return pageInfo;
    }

    @Override
    public int selectCountByGroupId(String groupId) {
        LOGGER.debug("begin to get count by groupId={}", (Object)groupId);
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return 0;
        }
        int count = this.streamMapper.selectCountByGroupId(groupId);
        LOGGER.info("success to get count");
        return count;
    }

    @Override
    public List<InlongStreamBriefInfo> getTopicList(String groupId) {
        LOGGER.debug("begin bo get topic list by group id={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        List topicList = this.streamMapper.selectBriefList(groupId);
        LOGGER.debug("success to get topic list by groupId={}", (Object)groupId);
        return topicList;
    }

    @Override
    public boolean updateAfterApprove(List<InlongStreamApproveRequest> streamApproveList, String operator) {
        if (CollectionUtils.isEmpty(streamApproveList)) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update stream after approve={}", streamApproveList);
        }
        String groupId = null;
        for (InlongStreamApproveRequest info : streamApproveList) {
            InlongStreamEntity streamEntity = new InlongStreamEntity();
            groupId = info.getInlongGroupId();
            streamEntity.setInlongGroupId(groupId);
            streamEntity.setInlongStreamId(info.getInlongStreamId());
            streamEntity.setStatus(StreamStatus.CONFIG_ING.getCode());
            this.streamMapper.updateByIdentifierSelective(streamEntity);
            this.sinkService.updateAfterApprove(info.getSinkList(), operator);
        }
        LOGGER.info("success to update stream after approve for groupId={}", groupId);
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean updateStatus(String groupId, String streamId, Integer status, String operator) {
        LOGGER.debug("begin to update status by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        this.streamMapper.updateStatusByIdentifier(groupId, streamId, status, operator);
        LOGGER.info("success to update stream after approve for groupId=" + groupId + ", streamId=" + streamId);
        return true;
    }

    @Override
    public void insertDlqOrRlq(String groupId, String topicName, String operator) {
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, topicName);
        if (count >= 1) {
            LOGGER.error("DLQ/RLQ topic already exists with name={}", (Object)topicName);
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_DUPLICATE, "DLQ/RLQ topic already exists");
        }
        InlongStreamEntity streamEntity = new InlongStreamEntity();
        streamEntity.setInlongGroupId(groupId);
        streamEntity.setInlongStreamId(topicName);
        streamEntity.setMqResource(topicName);
        streamEntity.setDescription("This is DLQ / RLQ topic created by SYSTEM");
        streamEntity.setDailyRecords(Integer.valueOf(1000));
        streamEntity.setDailyStorage(Integer.valueOf(1000));
        streamEntity.setPeakRecords(Integer.valueOf(1000));
        streamEntity.setMaxLength(Integer.valueOf(1000));
        streamEntity.setStatus(StreamStatus.CONFIG_SUCCESSFUL.getCode());
        streamEntity.setIsDeleted(GlobalConstants.UN_DELETED);
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        Date now = new Date();
        streamEntity.setCreateTime(now);
        streamEntity.setModifyTime(now);
        this.streamMapper.insert(streamEntity);
    }

    @Override
    public void logicDeleteDlqOrRlq(String groupId, String topicName, String operator) {
        this.streamMapper.logicDeleteDlqOrRlq(groupId, topicName, operator);
        LOGGER.info("success to logic delete dlq or rlq by groupId={}, topicName={}", (Object)groupId, (Object)topicName);
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateField(String groupId, String streamId, List<StreamField> fieldList) {
        LOGGER.debug("begin to update inlong stream field, groupId={}, streamId={}, field={}", new Object[]{groupId, streamId, fieldList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.saveField(groupId, streamId, fieldList);
            LOGGER.info("success to update inlong stream field for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update inlong stream field: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.STREAM_FIELD_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveField(String groupId, String streamId, List<StreamField> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        infoList.stream().forEach(streamField -> streamField.setId(null));
        List list = CommonBeanUtils.copyListProperties(infoList, InlongStreamFieldEntity::new);
        for (InlongStreamFieldEntity entity : list) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setIsDeleted(GlobalConstants.UN_DELETED);
        }
        this.streamFieldMapper.insertAll(list);
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveOrUpdateExt(String groupId, String streamId, List<InlongStreamExtInfo> exts) {
        LOGGER.info("begin to save or update inlong stream ext info, groupId={}, streamId={}, ext={}", new Object[]{groupId, streamId, exts});
        if (CollectionUtils.isEmpty(exts)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(exts, InlongStreamExtEntity::new);
        entityList.forEach(streamEntity -> {
            streamEntity.setInlongGroupId(groupId);
            streamEntity.setInlongStreamId(streamId);
        });
        this.streamExtMapper.insertOnDuplicateKeyUpdate(entityList);
        LOGGER.info("success to save or update inlong stream ext for groupId={}", (Object)groupId);
    }

    private InlongGroupEntity checkGroupStatusIsTemp(String groupId) {
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)entity, (String)"groupId is invalid");
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.isTempStatus((GroupStatus)curState)) {
            LOGGER.error("inlong group status was not allowed to add/update/delete inlong stream");
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED);
        }
        return entity;
    }

    private void checkCanUpdate(Integer groupStatus, InlongStreamEntity streamEntity, InlongStreamRequest request) {
        List<Integer> statusList;
        if (streamEntity == null || request == null) {
            return;
        }
        if (GroupStatus.CONFIG_SUCCESSFUL.getCode().equals(groupStatus)) {
            this.checkUpdatedFields(streamEntity, request);
        }
        if ((statusList = Arrays.asList(GroupStatus.TO_BE_SUBMIT.getCode(), GroupStatus.APPROVE_REJECTED.getCode(), GroupStatus.CONFIG_FAILED.getCode())).contains(groupStatus)) {
            String groupId = request.getInlongGroupId();
            String streamId = request.getInlongStreamId();
            int sourceCount = this.sourceService.getCount(groupId, streamId);
            int sinkCount = this.sinkService.getCount(groupId, streamId);
            if (sourceCount > 0 || sinkCount > 0) {
                this.checkUpdatedFields(streamEntity, request);
            }
        }
    }

    private void checkUpdatedFields(InlongStreamEntity streamEntity, InlongStreamRequest request) {
        String newGroupId = request.getInlongGroupId();
        if (newGroupId != null && !newGroupId.equals(streamEntity.getInlongGroupId())) {
            LOGGER.error("current status was not allowed to update inlong group id");
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_UPDATE_NOT_ALLOWED);
        }
        String newStreamId = request.getInlongStreamId();
        if (newStreamId != null && !newStreamId.equals(streamEntity.getInlongStreamId())) {
            LOGGER.error("current status was not allowed to update inlong stream id");
            throw new BusinessException(ErrorCodeEnum.STREAM_ID_UPDATE_NOT_ALLOWED);
        }
    }
}

