/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.inlong.common.pojo.sdk.CacheZone;
import org.apache.inlong.common.pojo.sdk.Topic;
import org.apache.inlong.manager.dao.entity.SortSourceConfigEntity;
import org.apache.inlong.manager.dao.mapper.SortSourceConfigEntityMapper;
import org.apache.inlong.manager.service.core.SortSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortSourceServiceImpl
implements SortSourceService {
    private static final String KEY_TOPIC_PARTITION_COUNT = "partitionCnt";
    private static final String KEY_ZONE_SERVICE_URL = "serviceUrl";
    private static final String KEY_ZONE_AUTHENTICATION = "authentication";
    private static final String KEY_ZONE_TYPE = "zoneType";
    @Autowired
    private SortSourceConfigEntityMapper sortSourceConfigEntityMapper;

    @Override
    public Map<String, CacheZone> getCacheZones(String clusterName, String taskName) {
        List configList = this.sortSourceConfigEntityMapper.selectByClusterAndTask(clusterName, taskName);
        Map<String, List<SortSourceConfigEntity>> zoneConfigMap = configList.stream().collect(Collectors.groupingBy(SortSourceConfigEntity::getZoneName));
        return zoneConfigMap.values().stream().map(this::toCacheZone).collect(Collectors.toMap(CacheZone::getZoneName, cacheZone -> cacheZone));
    }

    private CacheZone toCacheZone(List<SortSourceConfigEntity> configList) {
        List topicList = configList.stream().filter(config -> StringUtil.isNotBlank((String)config.getTopic())).map(this::toTopic).collect(Collectors.toList());
        List zoneConfigs = configList.stream().filter(config -> StringUtil.isBlank((String)config.getTopic())).collect(Collectors.toList());
        if (zoneConfigs.size() != 1) {
            throw new IllegalStateException("The size of zone config should be 1, but found " + zoneConfigs.size());
        }
        SortSourceConfigEntity zoneConfig = (SortSourceConfigEntity)zoneConfigs.get(0);
        Map<String, String> zoneProperties = this.jsonProperty2Map(zoneConfig.getExtParams());
        return CacheZone.builder().zoneName(zoneConfig.getZoneName()).serviceUrl(zoneProperties.remove(KEY_ZONE_SERVICE_URL)).authentication(zoneProperties.remove(KEY_ZONE_AUTHENTICATION)).topics(topicList).zoneType(zoneProperties.remove(KEY_ZONE_TYPE)).cacheZoneProperties(zoneProperties).build();
    }

    private Topic toTopic(SortSourceConfigEntity topicConfig) {
        Map<String, String> topicProperties = this.jsonProperty2Map(topicConfig.getExtParams());
        int partitionCnt = Integer.parseInt(topicProperties.remove(KEY_TOPIC_PARTITION_COUNT));
        return Topic.builder().topic(topicConfig.getTopic()).partitionCnt(partitionCnt).topicProperties(topicProperties).build();
    }

    private Map<String, String> jsonProperty2Map(String jsonProperty) {
        return (Map)new Gson().fromJson(jsonProperty, Map.class);
    }
}

