/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.operation;

import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.consumption.ConsumptionInfo;
import org.apache.inlong.manager.common.pojo.consumption.ConsumptionMqExtBase;
import org.apache.inlong.manager.common.pojo.consumption.ConsumptionPulsarInfo;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.pojo.workflow.form.NewConsumptionProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ConsumptionPulsarEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionPulsarEntityMapper;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumptionProcessOperation {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionProcessOperation.class);
    @Autowired
    private ConsumptionService consumptionService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private ConsumptionPulsarEntityMapper consumptionPulsarMapper;

    public WorkflowResult startProcess(Integer id, String operator) {
        ConsumptionInfo consumptionInfo = this.consumptionService.get(id);
        Preconditions.checkTrue((boolean)ConsumptionStatus.ALLOW_START_WORKFLOW_STATUS.contains(ConsumptionStatus.fromStatus((int)consumptionInfo.getStatus())), (String)"current status not allow start workflow");
        consumptionInfo.setStatus(Integer.valueOf(ConsumptionStatus.WAIT_APPROVE.getStatus()));
        boolean isSuccess = this.consumptionService.update(consumptionInfo, operator);
        Preconditions.checkTrue((boolean)isSuccess, (String)"update consumption failed");
        return this.workflowService.start(ProcessName.NEW_CONSUMPTION_PROCESS, operator, (ProcessForm)this.genNewConsumptionProcessForm(consumptionInfo));
    }

    private NewConsumptionProcessForm genNewConsumptionProcessForm(ConsumptionInfo consumptionInfo) {
        NewConsumptionProcessForm form = new NewConsumptionProcessForm();
        Integer id = consumptionInfo.getId();
        MQType mqType = MQType.forType((String)consumptionInfo.getMqType());
        if (mqType == MQType.PULSAR || mqType == MQType.TDMQ_PULSAR) {
            ConsumptionPulsarEntity consumptionPulsarEntity = this.consumptionPulsarMapper.selectByConsumptionId(id);
            ConsumptionPulsarInfo pulsarInfo = (ConsumptionPulsarInfo)CommonBeanUtils.copyProperties((Object)consumptionPulsarEntity, ConsumptionPulsarInfo::new);
            consumptionInfo.setMqExtInfo((ConsumptionMqExtBase)pulsarInfo);
        }
        form.setConsumptionInfo(consumptionInfo);
        return form;
    }
}

