/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.operation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupMode;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupProcessOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupProcessOperation.class);
    private final ExecutorService executorService = new ThreadPoolExecutor(20, 40, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("inlong-group-process-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongStreamService streamService;

    public WorkflowResult startProcess(String groupId, String operator) {
        LOGGER.info("begin to start approve process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.TO_BE_APPROVAL.getCode(), operator);
        NewGroupProcessForm form = this.genNewGroupProcessForm(groupId);
        return this.workflowService.start(ProcessName.NEW_GROUP_PROCESS, operator, (ProcessForm)form);
    }

    public String suspendProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to suspend process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.SUSPENDING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                GroupResourceProcessForm form = this.genGroupProcessForm(groupInfo, GroupOperateType.SUSPEND);
                this.executorService.execute(() -> this.workflowService.start(ProcessName.SUSPEND_GROUP_PROCESS, operator, (ProcessForm)form));
                break;
            }
            case LIGHT: {
                LightGroupResourceProcessForm lightForm = this.genLightGroupProcessForm(groupInfo, GroupOperateType.SUSPEND);
                this.executorService.execute(() -> this.workflowService.start(ProcessName.SUSPEND_LIGHT_GROUP_PROCESS, operator, (ProcessForm)lightForm));
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
        return groupId;
    }

    public WorkflowResult suspendProcess(String groupId, String operator) {
        WorkflowResult result;
        LOGGER.info("begin to suspend process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.SUSPENDING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                GroupResourceProcessForm form = this.genGroupProcessForm(groupInfo, GroupOperateType.SUSPEND);
                result = this.workflowService.start(ProcessName.SUSPEND_GROUP_PROCESS, operator, (ProcessForm)form);
                break;
            }
            case LIGHT: {
                LightGroupResourceProcessForm lightForm = this.genLightGroupProcessForm(groupInfo, GroupOperateType.SUSPEND);
                result = this.workflowService.start(ProcessName.SUSPEND_LIGHT_GROUP_PROCESS, operator, (ProcessForm)lightForm);
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
        return result;
    }

    public String restartProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to restart process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.RESTARTING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                GroupResourceProcessForm form = this.genGroupProcessForm(groupInfo, GroupOperateType.RESTART);
                this.executorService.execute(() -> this.workflowService.start(ProcessName.RESTART_GROUP_PROCESS, operator, (ProcessForm)form));
                break;
            }
            case LIGHT: {
                LightGroupResourceProcessForm lightForm = this.genLightGroupProcessForm(groupInfo, GroupOperateType.RESTART);
                this.executorService.execute(() -> this.workflowService.start(ProcessName.RESTART_LIGHT_GROUP_PROCESS, operator, (ProcessForm)lightForm));
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
        return groupId;
    }

    public WorkflowResult restartProcess(String groupId, String operator) {
        WorkflowResult result;
        LOGGER.info("begin to restart process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupStatus.RESTARTING.getCode(), operator);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                GroupResourceProcessForm form = this.genGroupProcessForm(groupInfo, GroupOperateType.RESTART);
                result = this.workflowService.start(ProcessName.RESTART_GROUP_PROCESS, operator, (ProcessForm)form);
                break;
            }
            case LIGHT: {
                LightGroupResourceProcessForm lightForm = this.genLightGroupProcessForm(groupInfo, GroupOperateType.RESTART);
                result = this.workflowService.start(ProcessName.RESTART_LIGHT_GROUP_PROCESS, operator, (ProcessForm)lightForm);
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
        return result;
    }

    public String deleteProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to delete process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.executorService.execute(() -> {
            try {
                this.invokeDeleteProcess(groupId, operator);
            }
            catch (Exception ex) {
                LOGGER.error("exception while delete process, groupId = {}, operator = {}", new Object[]{groupId, operator, ex});
                throw ex;
            }
            this.groupService.delete(groupId, operator);
        });
        return groupId;
    }

    public boolean deleteProcess(String groupId, String operator) {
        LOGGER.info("begin to delete process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        try {
            this.invokeDeleteProcess(groupId, operator);
        }
        catch (Exception ex) {
            LOGGER.error("exception while delete process, groupId = {}, operator = {}", new Object[]{groupId, operator, ex});
            throw ex;
        }
        return this.groupService.delete(groupId, operator);
    }

    private void invokeDeleteProcess(String groupId, String operator) {
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                GroupResourceProcessForm form = this.genGroupProcessForm(groupInfo, GroupOperateType.DELETE);
                this.workflowService.start(ProcessName.DELETE_GROUP_PROCESS, operator, (ProcessForm)form);
                break;
            }
            case LIGHT: {
                LightGroupResourceProcessForm lightForm = this.genLightGroupProcessForm(groupInfo, GroupOperateType.DELETE);
                this.workflowService.start(ProcessName.DELETE_LIGHT_GROUP_PROCESS, operator, (ProcessForm)lightForm);
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
    }

    private NewGroupProcessForm genNewGroupProcessForm(String groupId) {
        NewGroupProcessForm form = new NewGroupProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        form.setGroupInfo(groupInfo);
        List<StreamBriefResponse> infoList = this.streamService.getBriefList(groupInfo.getInlongGroupId());
        form.setStreamInfoList(infoList);
        return form;
    }

    private GroupResourceProcessForm genGroupProcessForm(InlongGroupInfo groupInfo, GroupOperateType operateType) {
        GroupResourceProcessForm form = new GroupResourceProcessForm();
        String groupId = groupInfo.getInlongGroupId();
        if (GroupOperateType.RESTART == operateType) {
            List<InlongStreamInfo> streamList = this.streamService.list(groupId);
            form.setStreamInfos(streamList);
        }
        form.setGroupInfo(groupInfo);
        form.setGroupOperateType(operateType);
        return form;
    }

    private LightGroupResourceProcessForm genLightGroupProcessForm(InlongGroupInfo groupInfo, GroupOperateType operateType) {
        LightGroupResourceProcessForm form = new LightGroupResourceProcessForm();
        form.setGroupInfo(groupInfo);
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamInfo> streamList = this.streamService.list(groupId);
        form.setStreamInfos(streamList);
        form.setGroupOperateType(operateType);
        return form;
    }
}

