/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.common.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractGroupOperator
implements InlongGroupOperator {
    @Autowired
    protected InlongGroupEntityMapper groupMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String saveOpt(InlongGroupRequest request, String operator) {
        String groupId = request.getInlongGroupId();
        InlongGroupEntity entity = (InlongGroupEntity)CommonBeanUtils.copyProperties((Object)request, InlongGroupEntity::new);
        if (StringUtils.isEmpty((CharSequence)entity.getMqResource())) {
            entity.setMqResource(groupId);
        }
        this.setTargetEntity(request, entity);
        entity.setStatus(GroupStatus.TO_BE_SUBMIT.getCode());
        entity.setIsDeleted(GlobalConstants.UN_DELETED);
        entity.setCreator(operator);
        entity.setCreateTime(new Date());
        this.groupMapper.insert(entity);
        return groupId;
    }

    protected abstract void setTargetEntity(InlongGroupRequest var1, InlongGroupEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(InlongGroupRequest request, String operator) {
        InlongGroupEntity entity = (InlongGroupEntity)CommonBeanUtils.copyProperties((Object)request, InlongGroupEntity::new);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        this.groupMapper.updateByIdentifierSelective(entity);
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        InlongGroupTopicInfo topicInfo = new InlongGroupTopicInfo();
        topicInfo.setInlongGroupId(groupInfo.getInlongGroupId());
        topicInfo.setMqType(groupInfo.getMqType());
        topicInfo.setMqResource(groupInfo.getMqResource());
        return topicInfo;
    }
}

