/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.Arrays;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupCheckService.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;

    public InlongGroupEntity checkGroupStatus(String groupId, String operator) {
        InlongGroupEntity inlongGroupEntity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)inlongGroupEntity, (String)"groupId is invalid");
        List<String> managers = Arrays.asList(inlongGroupEntity.getInCharges().split(","));
        Preconditions.checkTrue((boolean)managers.contains(operator), (String)String.format(ErrorCodeEnum.USER_IS_NOT_MANAGER.getMessage(), operator, managers));
        GroupStatus state = GroupStatus.forCode((int)inlongGroupEntity.getStatus());
        if (GroupStatus.notAllowedUpdate((GroupStatus)state)) {
            LOGGER.error("inlong group status was not allowed to add/update/delete related info");
            throw new BusinessException(ErrorCodeEnum.OPT_NOT_ALLOWED_BY_STATUS);
        }
        return inlongGroupEntity;
    }
}

