/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.mq;

import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.cluster.tube.TubeClusterInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.mq.util.TubeMQOperator;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeGroupTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeGroupTaskListener.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private TubeMQOperator tubeMQOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create tube consumer group for groupId {}", (Object)groupId);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        String clusterTag = groupEntity.getInlongClusterTag();
        TubeClusterInfo tubeCluster = (TubeClusterInfo)this.clusterService.getOne(clusterTag, null, "TUBE");
        String topicName = groupEntity.getMqResource();
        String consumeGroup = clusterTag + "_" + topicName + "_consumer_group";
        try {
            this.tubeMQOperator.createConsumerGroup(tubeCluster, topicName, consumeGroup, context.getOperator());
        }
        catch (Exception e) {
            throw new WorkflowListenerException("create tube consumer group for groupId=" + groupId + " error", (Throwable)e);
        }
        log.info("finish to create tube consumer group for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

