/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.mq;

import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.tube.TubeClusterInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.mq.util.TubeMQOperator;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeTopicTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeTopicTaskListener.class);
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private TubeMQOperator tubeMQOperator;
    @Autowired
    private InlongGroupService groupService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        log.info("begin create tube topic for groupId={}", (Object)form.getInlongGroupId());
        String groupId = form.getInlongGroupId();
        try {
            InlongGroupInfo groupInfo = form.getGroupInfo();
            String clusterTag = groupInfo.getInlongClusterTag();
            InlongClusterInfo clusterInfo = this.clusterService.getOne(clusterTag, null, "TUBE");
            this.tubeMQOperator.createTopic((TubeClusterInfo)clusterInfo, groupInfo.getMqResource(), context.getOperator());
            log.info("finish to create tube topic for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            log.error("create tube topic for groupId={} error, exception {} ", new Object[]{groupId, e.getMessage(), e});
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

