/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.mq;

import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarTopicSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(PulsarTopicSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            return false;
        }
        StreamResourceProcessForm streamResourceProcessForm = (StreamResourceProcessForm)processForm;
        MQType mqType = MQType.forType((String)streamResourceProcessForm.getGroupInfo().getMqType());
        if (mqType == MQType.PULSAR || mqType == MQType.TDMQ_PULSAR) {
            return true;
        }
        InlongStreamInfo streamInfo = streamResourceProcessForm.getStreamInfo();
        log.warn("no need to create pulsar topic for groupId={}, streamId={}, as the middlewareType={}", new Object[]{streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId(), mqType});
        return false;
    }
}

