/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.mq;

import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeEventSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(TubeEventSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            return false;
        }
        GroupResourceProcessForm form = (GroupResourceProcessForm)processForm;
        String groupId = form.getInlongGroupId();
        MQType mqType = MQType.forType((String)form.getGroupInfo().getMqType());
        if (mqType == MQType.TUBE) {
            log.info("need to create tube resource for groupId [{}]", (Object)groupId);
            return true;
        }
        log.warn("skip to to create tube resource as the mq type is {} for groupId [{}]", (Object)mqType, (Object)groupId);
        return false;
    }
}

