/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.repository;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterObject;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterSetObject;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.common.pojo.dataproxy.IRepository;
import org.apache.inlong.common.pojo.dataproxy.InLongIdObject;
import org.apache.inlong.common.pojo.dataproxy.ProxyClusterObject;
import org.apache.inlong.common.pojo.dataproxy.RepositoryTimerTask;
import org.apache.inlong.manager.common.pojo.dataproxy.CacheCluster;
import org.apache.inlong.manager.common.pojo.dataproxy.InlongGroupId;
import org.apache.inlong.manager.common.pojo.dataproxy.InlongStreamId;
import org.apache.inlong.manager.common.pojo.dataproxy.ProxyCluster;
import org.apache.inlong.manager.dao.mapper.ClusterSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="dataProxyConfigRepository")
public class DataProxyConfigRepository
implements IRepository {
    public static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    public static final String CACHE_CLUSTER_PRODUCER_TAG = "producer";
    public static final String CACHE_CLUSTER_CONSUMER_TAG = "consumer";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyConfigRepository.class);
    private static final Gson gson = new Gson();
    private Map<String, String> proxyConfigJson = new ConcurrentHashMap<String, String>();
    private Map<String, String> proxyMd5Map = new ConcurrentHashMap<String, String>();
    private long reloadInterval;
    @Autowired
    private ClusterSetMapper clusterSetMapper;

    @PostConstruct
    public void initialize() {
        LOGGER.info("create repository for " + DataProxyConfigRepository.class.getSimpleName());
        try {
            this.reloadInterval = 60000L;
            this.reload();
            this.setReloadTimer();
        }
        catch (Throwable t) {
            LOGGER.error("Initialize DataProxyConfigRepository error", t);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void reload() {
        LOGGER.info("start to reload config.");
        Map<String, ProxyClusterObject> proxyClusterMap = this.reloadProxyCluster();
        if (proxyClusterMap.size() == 0) {
            return;
        }
        Map<String, Map<String, List<CacheCluster>>> cacheClusterMap = this.reloadCacheCluster();
        Map<String, List<InLongIdObject>> inlongIdMap = this.reloadInlongId();
        for (Map.Entry<String, ProxyClusterObject> entry : proxyClusterMap.entrySet()) {
            String clusterTag = entry.getValue().getSetName();
            List<InLongIdObject> inlongIds = inlongIdMap.get(clusterTag);
            if (inlongIds == null) continue;
            entry.getValue().setInlongIds(inlongIds);
        }
        this.generateClusterJson(proxyClusterMap, cacheClusterMap);
        LOGGER.info("end to reload config.");
    }

    private Map<String, ProxyClusterObject> reloadProxyCluster() {
        HashMap<String, ProxyClusterObject> proxyClusterMap = new HashMap<String, ProxyClusterObject>();
        for (ProxyCluster proxyCluster : this.clusterSetMapper.selectProxyCluster()) {
            ProxyClusterObject obj = new ProxyClusterObject();
            obj.setName(proxyCluster.getClusterName());
            obj.setSetName(proxyCluster.getClusterTag());
            obj.setZone(proxyCluster.getExtTag());
            proxyClusterMap.put(obj.getName(), obj);
        }
        return proxyClusterMap;
    }

    private Map<String, Map<String, List<CacheCluster>>> reloadCacheCluster() {
        HashMap<String, Map<String, List<CacheCluster>>> cacheClusterMap = new HashMap<String, Map<String, List<CacheCluster>>>();
        for (CacheCluster cacheCluster : this.clusterSetMapper.selectCacheCluster()) {
            Map tagMap;
            String producerTag;
            if (StringUtils.isEmpty((CharSequence)cacheCluster.getExtTag()) || !StringUtils.equalsIgnoreCase((CharSequence)(producerTag = (tagMap = MAP_SPLITTER.split((CharSequence)cacheCluster.getExtTag())).getOrDefault(CACHE_CLUSTER_PRODUCER_TAG, Boolean.TRUE.toString())), (CharSequence)Boolean.TRUE.toString())) continue;
            cacheClusterMap.computeIfAbsent(cacheCluster.getClusterTag(), k -> new HashMap()).computeIfAbsent(cacheCluster.getExtTag(), k -> new ArrayList()).add(cacheCluster);
        }
        return cacheClusterMap;
    }

    private Map<String, List<InLongIdObject>> reloadInlongId() {
        HashMap groupIdMap = new HashMap();
        this.clusterSetMapper.selectInlongGroupId().forEach(value -> groupIdMap.put(value.getInlongGroupId(), value));
        HashMap<String, List<InLongIdObject>> inlongIdMap = new HashMap<String, List<InLongIdObject>>();
        for (InlongStreamId streamIdObj : this.clusterSetMapper.selectInlongStreamId()) {
            String groupId = streamIdObj.getInlongGroupId();
            InlongGroupId groupIdObj = (InlongGroupId)groupIdMap.get(groupId);
            if (groupId == null) continue;
            String groupTopic = groupIdObj.getTopic();
            String streamTopic = streamIdObj.getTopic();
            String finalTopic = null;
            if (StringUtils.isEmpty((CharSequence)groupTopic)) {
                if (StringUtils.isEmpty((CharSequence)streamTopic)) continue;
                finalTopic = streamTopic;
            } else {
                finalTopic = StringUtils.isEmpty((CharSequence)streamTopic) ? groupTopic : groupTopic + "/" + streamTopic;
            }
            InLongIdObject obj = new InLongIdObject();
            String inlongId = groupId + "." + streamIdObj.getInlongStreamId();
            obj.setInlongId(inlongId);
            obj.setTopic(finalTopic);
            HashMap params = new HashMap();
            obj.setParams(params);
            if (!StringUtils.isEmpty((CharSequence)groupIdObj.getExtParams())) {
                try {
                    Map groupParams = (Map)gson.fromJson(groupIdObj.getExtParams(), Map.class);
                    params.putAll(groupParams);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)streamIdObj.getExtParams())) {
                try {
                    Map streamParams = (Map)gson.fromJson(streamIdObj.getExtParams(), Map.class);
                    params.putAll(streamParams);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inlongIdMap.computeIfAbsent(groupIdObj.getClusterTag(), k -> new ArrayList()).add(obj);
        }
        return inlongIdMap;
    }

    private void setReloadTimer() {
        Timer reloadTimer = new Timer(true);
        RepositoryTimerTask task = new RepositoryTimerTask((IRepository)this);
        reloadTimer.scheduleAtFixedRate((TimerTask)task, this.reloadInterval, this.reloadInterval);
    }

    private void generateClusterJson(Map<String, ProxyClusterObject> proxyClusterMap, Map<String, Map<String, List<CacheCluster>>> cacheClusterMap) {
        ConcurrentHashMap<String, String> newProxyConfigJson = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> newProxyMd5Map = new ConcurrentHashMap<String, String>();
        HashMap<String, Map> tagCache = new HashMap<String, Map>();
        for (Map.Entry<String, ProxyClusterObject> entry : proxyClusterMap.entrySet()) {
            ProxyClusterObject proxyObj = entry.getValue();
            DataProxyCluster clusterObj = new DataProxyCluster();
            clusterObj.setProxyCluster(proxyObj);
            String clusterTag = proxyObj.getSetName();
            String extTag = proxyObj.getZone();
            Map<String, List<CacheCluster>> cacheClusterZoneMap = cacheClusterMap.get(clusterTag);
            if (cacheClusterZoneMap != null) {
                Map subTagMap = tagCache.computeIfAbsent(extTag, k -> MAP_SPLITTER.split((CharSequence)extTag));
                for (Map.Entry<String, List<CacheCluster>> cacheEntry : cacheClusterZoneMap.entrySet()) {
                    Map wholeTagMap;
                    if (cacheEntry.getValue().size() == 0 || !this.isSubTag(wholeTagMap = tagCache.computeIfAbsent(cacheEntry.getKey(), k -> MAP_SPLITTER.split((CharSequence)cacheEntry.getKey())), subTagMap)) continue;
                    CacheClusterSetObject cacheSet = clusterObj.getCacheClusterSet();
                    cacheSet.setSetName(clusterTag);
                    List<CacheCluster> cacheClusterList = cacheEntry.getValue();
                    cacheSet.setType(cacheClusterList.get(0).getType());
                    ArrayList<CacheClusterObject> cacheClusters = new ArrayList<CacheClusterObject>(cacheClusterList.size());
                    cacheSet.setCacheClusters(cacheClusters);
                    for (CacheCluster cacheCluster : cacheClusterList) {
                        CacheClusterObject obj = new CacheClusterObject();
                        obj.setName(cacheCluster.getClusterName());
                        obj.setZone(cacheCluster.getExtTag());
                        try {
                            Map params = (Map)gson.fromJson(cacheCluster.getExtParams(), Map.class);
                            obj.setParams(params);
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                        cacheClusters.add(obj);
                    }
                }
            }
            String jsonDataProxyCluster = gson.toJson((Object)clusterObj);
            String md5 = DigestUtils.md5Hex((String)jsonDataProxyCluster);
            DataProxyConfigResponse response = new DataProxyConfigResponse();
            response.setResult(Boolean.valueOf(true));
            response.setErrCode(Integer.valueOf(0));
            response.setMd5(md5);
            response.setData(clusterObj);
            String jsonResponse = gson.toJson((Object)response);
            newProxyConfigJson.put(proxyObj.getName(), jsonResponse);
            newProxyMd5Map.put(proxyObj.getName(), md5);
        }
        this.proxyConfigJson = newProxyConfigJson;
        this.proxyMd5Map = newProxyMd5Map;
    }

    private boolean isSubTag(Map<String, String> wholeTagMap, Map<String, String> subTagMap) {
        for (Map.Entry<String, String> entry : subTagMap.entrySet()) {
            String value = wholeTagMap.get(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String getProxyMd5(String clusterName) {
        return this.proxyMd5Map.get(clusterName);
    }

    public String getProxyConfigJson(String clusterName) {
        return this.proxyConfigJson.get(clusterName);
    }
}

