/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.SinkResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinkResourceListener
implements SinkOperateListener {
    private static final Logger log = LoggerFactory.getLogger(SinkResourceListener.class);
    @Autowired
    private StreamSinkEntityMapper sinkMapper;
    @Autowired
    private SinkResourceOperatorFactory resourceOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        List configList;
        List needCreateList;
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create sink resources for groupId={}", (Object)groupId);
        List<Object> streamIdList = new ArrayList();
        List streamList = form.getStreamInfos();
        if (CollectionUtils.isNotEmpty((Collection)streamList)) {
            streamIdList = streamList.stream().map(InlongStreamInfo::getInlongStreamId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(needCreateList = (configList = this.sinkMapper.selectAllConfig(groupId, streamIdList)).stream().filter(sinkInfo -> GlobalConstants.ENABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())).collect(Collectors.toList()))) {
            String result = "sink resources have been created for group [" + groupId + "] and stream " + streamIdList;
            log.info(result);
            return ListenerResult.success((String)result);
        }
        for (SinkInfo sinkConfig : needCreateList) {
            String sinkType = sinkConfig.getSinkType();
            SinkResourceOperator resourceOperator = this.resourceOperatorFactory.getInstance(SinkType.forType((String)sinkType));
            resourceOperator.createSinkResource(sinkConfig);
        }
        String result = "success to create sink resources for group [" + groupId + "] and stream " + streamIdList;
        log.info(result);
        return ListenerResult.success((String)result);
    }

    public boolean async() {
        return false;
    }
}

