/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.SinkResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamSinkResourceListener
implements SinkOperateListener {
    private static final Logger log = LoggerFactory.getLogger(StreamSinkResourceListener.class);
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private SinkResourceOperatorFactory resourceOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        log.info("begin to create sink resource for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        List sinkInfos = this.sinkEntityMapper.selectAllConfig(groupId, (List)Lists.newArrayList((Object[])new String[]{streamId}));
        List needCreateResources = sinkInfos.stream().filter(sinkInfo -> GlobalConstants.ENABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(needCreateResources)) {
            String result = "sink resources have been created for group [" + groupId + "] and stream [" + streamId + "]";
            log.info(result);
            return ListenerResult.success((String)result);
        }
        for (SinkInfo sinkInfo2 : needCreateResources) {
            String sinkType = sinkInfo2.getSinkType();
            SinkResourceOperator resourceOperator = this.resourceOperatorFactory.getInstance(SinkType.forType((String)sinkType));
            resourceOperator.createSinkResource(sinkInfo2);
        }
        String result = "success to create sink resources for group [" + groupId + "] and stream [" + streamId + "]";
        log.info(result);
        return ListenerResult.success((String)result);
    }

    public boolean async() {
        return false;
    }
}

