/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.ck;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.sink.ck.ClickHouseColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.ck.ClickHouseTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseSqlBuilder {
    private static final int FIRST_COLUMN_INDEX = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseSqlBuilder.class);

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE IF NOT EXISTS " + dbName;
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(ClickHouseTableInfo table) {
        StringBuilder sql = new StringBuilder();
        String dbTableName = table.getDbName() + "." + table.getTableName();
        sql.append("CREATE TABLE ").append(dbTableName);
        sql.append(ClickHouseSqlBuilder.buildCreateColumnsSql(table.getColumns()));
        if (StringUtils.isNotEmpty((CharSequence)table.getEngine())) {
            sql.append(" ENGINE = ").append(table.getEngine());
        } else {
            sql.append(" ENGINE = MergeTree()");
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getOrderBy())) {
            sql.append(" ORDER BY ").append(table.getOrderBy());
        } else if (StringUtils.isEmpty((CharSequence)table.getEngine())) {
            sql.append(" ORDER BY ").append(((ClickHouseColumnInfo)table.getColumns().get(0)).getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getPartitionBy())) {
            sql.append(" PARTITION BY ").append(table.getPartitionBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getPrimaryKey())) {
            sql.append(" PRIMARY KEY ").append(table.getPrimaryKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getTableDesc())) {
            sql.append(" COMMENT '").append(table.getTableDesc()).append("'");
        }
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static List<String> buildAddColumnsSql(String dbName, String tableName, List<ClickHouseColumnInfo> columnList) {
        String dbTableName = dbName + "." + tableName;
        List<String> columnInfoList = ClickHouseSqlBuilder.getColumnsInfo(columnList);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String columnInfo : columnInfoList) {
            StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(dbTableName).append(" ADD COLUMN ").append(columnInfo);
            resultList.add(sql.toString());
        }
        return resultList;
    }

    private static String buildCreateColumnsSql(List<ClickHouseColumnInfo> columns) {
        List<String> columnList = ClickHouseSqlBuilder.getColumnsInfo(columns);
        StringBuilder result = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)",")).append(") ");
        return result.toString();
    }

    private static List<String> getColumnsInfo(List<ClickHouseColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        for (ClickHouseColumnInfo columnInfo : columns) {
            StringBuilder columnStr = new StringBuilder().append(columnInfo.getName()).append(" ").append(columnInfo.getType());
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getDefaultType())) {
                columnStr.append(" ").append(columnInfo.getDefaultType()).append(" ").append(columnInfo.getDefaultExpr());
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getCompressionCode())) {
                columnStr.append(" CODEC(").append(columnInfo.getDesc()).append(")");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getTtlExpr())) {
                columnStr.append(" TTL ").append(columnInfo.getTtlExpr());
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getDesc())) {
                columnStr.append(" COMMENT '").append(columnInfo.getDesc()).append("'");
            }
            columnList.add(columnStr.toString());
        }
        return columnList;
    }

    public static String buildDescTableSql(String dbName, String tableName) {
        StringBuilder sql = new StringBuilder();
        String fullTableName = dbName + "." + tableName;
        sql.append("DESC ").append(fullTableName);
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

