/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.es;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.common.pojo.sink.es.ElasticsearchSinkDTO;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.es.ElasticsearchApi;
import org.apache.inlong.manager.service.resource.es.ElasticsearchConfig;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;

    @Override
    public Boolean accept(SinkType sinkType) {
        return SinkType.ELASTICSEARCH == sinkType;
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (GlobalConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createIndex(sinkInfo);
    }

    private void createIndex(SinkInfo sinkInfo) {
        LOGGER.info("begin to create ES Index for sinkId={}", (Object)sinkInfo.getId());
        List sinkList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)sinkList)) {
            LOGGER.warn("no es fields found, skip to create index for sinkId={}", (Object)sinkInfo.getId());
        }
        List<ElasticsearchFieldInfo> fieldList = this.getElasticsearchFieldFromSink(sinkList);
        try {
            ElasticsearchConfig config = new ElasticsearchConfig();
            ElasticsearchSinkDTO esInfo = ElasticsearchSinkDTO.getFromJson((String)sinkInfo.getExtParams());
            if (StringUtils.isNotEmpty((CharSequence)esInfo.getUsername())) {
                config.setAuthEnable(true);
                config.setUsername(esInfo.getUsername());
                config.setPassword(esInfo.getPassword());
            }
            config.setHost(esInfo.getHost());
            config.setPort(esInfo.getPort());
            ElasticsearchApi client = new ElasticsearchApi();
            client.setEsConfig(config);
            String indexName = ElasticsearchSinkDTO.getElasticSearchIndexName((ElasticsearchSinkDTO)esInfo, fieldList);
            boolean indexExists = client.indexExists(indexName);
            if (!indexExists) {
                client.createIndexAndMapping(indexName, fieldList);
            } else {
                client.addNotExistFields(indexName, fieldList);
            }
            String info = "success to create Elasticsearch resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create Elasticsearch index failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    public List<ElasticsearchFieldInfo> getElasticsearchFieldFromSink(List<StreamSinkFieldEntity> sinkList) {
        ArrayList<ElasticsearchFieldInfo> fieldList = new ArrayList<ElasticsearchFieldInfo>();
        for (StreamSinkFieldEntity entry : sinkList) {
            ElasticsearchFieldInfo fieldInfo = new ElasticsearchFieldInfo();
            fieldInfo.setName(entry.getFieldName());
            fieldInfo.setType(entry.getFieldType());
            fieldInfo.setFormat(entry.getFieldFormat());
            ElasticsearchFieldInfo fieldExtParams = ElasticsearchFieldInfo.getFromJson((String)entry.getExtParams());
            fieldInfo.setScalingFactor(fieldExtParams.getScalingFactor());
            fieldInfo.setAnalyzer(fieldExtParams.getAnalyzer());
            fieldInfo.setSearchAnalyzer(fieldExtParams.getSearchAnalyzer());
            fieldList.add(fieldInfo);
        }
        return fieldList;
    }
}

