/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseColumnFamilyInfo;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseApiUtils.class);
    private static final String HBASE_CONF_ZK_QUORUM = "hbase.zookeeper.quorum";
    private static final String HBASE_CONF_ZNODE_PARENT = "zookeeper.znode.parent";

    private static Connection getConnection(String zkAddress, String zkNode) throws Exception {
        Configuration config = HBaseConfiguration.create();
        config.set(HBASE_CONF_ZK_QUORUM, zkAddress);
        config.set(HBASE_CONF_ZNODE_PARENT, zkNode);
        return ConnectionFactory.createConnection((Configuration)config);
    }

    public static void createNamespace(String zkAddress, String zkNode, String namespace) throws Exception {
        if (namespace == null || namespace.isEmpty()) {
            return;
        }
        try (Connection conn = HBaseApiUtils.getConnection(zkAddress, zkNode);){
            Admin admin = conn.getAdmin();
            if (Arrays.asList(admin.listNamespaces()).contains(namespace)) {
                LOGGER.info("hbase namespace {} already exists", (Object)namespace);
                return;
            }
            admin.createNamespace(NamespaceDescriptor.create((String)namespace).build());
            LOGGER.info("hbase namespace {} created", (Object)namespace);
        }
    }

    public static void createTable(String zkAddress, String zkNode, HBaseTableInfo tableInfo) throws Exception {
        TableName tableName = TableName.valueOf((String)tableInfo.getNamespace(), (String)tableInfo.getTableName());
        TableDescriptorBuilder desc = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (HBaseColumnFamilyInfo cf : tableInfo.getColumnFamilies()) {
            desc.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)cf.getCfName()));
        }
        try (Connection conn = HBaseApiUtils.getConnection(zkAddress, zkNode);){
            Admin admin = conn.getAdmin();
            admin.createTable(desc.build());
        }
    }

    public static boolean tableExists(String zkAddress, String zkNode, String namespace, String qualifier) throws Exception {
        TableName tableName = TableName.valueOf((String)namespace, (String)qualifier);
        try (Connection conn = HBaseApiUtils.getConnection(zkAddress, zkNode);){
            Admin admin = conn.getAdmin();
            boolean bl = admin.tableExists(tableName);
            return bl;
        }
    }

    public static List<HBaseColumnFamilyInfo> getColumnFamilies(String zkAddress, String zkNode, String namespace, String qualifier) throws Exception {
        ArrayList<HBaseColumnFamilyInfo> cfList = new ArrayList<HBaseColumnFamilyInfo>();
        TableName tableName = TableName.valueOf((String)namespace, (String)qualifier);
        try (Connection conn = HBaseApiUtils.getConnection(zkAddress, zkNode);){
            Table table = conn.getTable(tableName);
            for (ColumnFamilyDescriptor cf : table.getDescriptor().getColumnFamilies()) {
                HBaseColumnFamilyInfo info = new HBaseColumnFamilyInfo();
                info.setCfName(cf.getNameAsString());
                info.setTtl(Integer.valueOf(cf.getTimeToLive()));
                cfList.add(info);
            }
        }
        return cfList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColumnFamilies(String zkAddress, String zkNode, String namespace, String qualifier, List<HBaseColumnFamilyInfo> columnFamilies) throws Exception {
        TableName tableName = TableName.valueOf((String)namespace, (String)qualifier);
        try (Connection conn = HBaseApiUtils.getConnection(zkAddress, zkNode);){
            Admin admin = conn.getAdmin();
            admin.disableTable(tableName);
            try {
                for (HBaseColumnFamilyInfo info : columnFamilies) {
                    admin.addColumnFamily(tableName, ColumnFamilyDescriptorBuilder.of((String)info.getCfName()));
                }
            }
            finally {
                admin.enableTable(tableName);
            }
        }
    }
}

