/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.hbase;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseColumnFamilyInfo;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseSinkDTO;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseTableInfo;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.hbase.HBaseApiUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HBaseResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;

    @Override
    public Boolean accept(SinkType sinkType) {
        return SinkType.HBASE == sinkType;
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (GlobalConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create hbase table for sinkInfo={}", (Object)sinkInfo);
        HBaseSinkDTO hbaseInfo = HBaseSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        List<HBaseColumnFamilyInfo> columnFamilies = this.getColumnFamilies(sinkInfo);
        if (CollectionUtils.isEmpty(columnFamilies)) {
            throw new IllegalArgumentException("no hbase column families specified");
        }
        HBaseTableInfo tableInfo = HBaseSinkDTO.getHbaseTableInfo((HBaseSinkDTO)hbaseInfo, columnFamilies);
        String zkAddress = hbaseInfo.getZkQuorum();
        String zkNode = hbaseInfo.getZkNodeParent();
        String namespace = hbaseInfo.getNamespace();
        String tableName = hbaseInfo.getTableName();
        try {
            HBaseApiUtils.createNamespace(zkAddress, zkNode, namespace);
            boolean tableExists = HBaseApiUtils.tableExists(zkAddress, zkNode, namespace, tableName);
            if (!tableExists) {
                HBaseApiUtils.createTable(zkAddress, zkNode, tableInfo);
            } else {
                List existColumnFamilies = HBaseApiUtils.getColumnFamilies(zkAddress, zkNode, namespace, tableName).stream().sorted(Comparator.comparing(HBaseColumnFamilyInfo::getCfName)).collect(Collectors.toList());
                List requestColumnFamilies = tableInfo.getColumnFamilies().stream().sorted(Comparator.comparing(HBaseColumnFamilyInfo::getCfName)).collect(Collectors.toList());
                List<HBaseColumnFamilyInfo> newColumnFamilies = requestColumnFamilies.stream().skip(existColumnFamilies.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(newColumnFamilies)) {
                    HBaseApiUtils.addColumnFamilies(zkAddress, zkNode, namespace, tableName, newColumnFamilies);
                    LOGGER.info("{} column families added for table {}", (Object)newColumnFamilies.size(), (Object)tableName);
                }
            }
            String info = "success to create hbase resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo = {}", (Object)info);
        }
        catch (Throwable e) {
            String errMsg = "create hbase table failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    private List<HBaseColumnFamilyInfo> getColumnFamilies(SinkInfo sinkInfo) {
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        HashSet<String> seen = new HashSet<String>();
        ArrayList<HBaseColumnFamilyInfo> columnFamilies = new ArrayList<HBaseColumnFamilyInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            HBaseColumnFamilyInfo columnFamily = HBaseColumnFamilyInfo.getFromJson((String)field.getExtParams());
            if (seen.contains(columnFamily.getCfName())) continue;
            seen.add(columnFamily.getCfName());
            columnFamilies.add(columnFamily);
        }
        return columnFamilies;
    }
}

