/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.hive;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.inlong.manager.common.pojo.sink.hive.HiveColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.hive.HiveTableInfo;
import org.apache.inlong.manager.service.resource.hive.SqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcUtils {
    private static final String HIVE_DRIVER_CLASS = "org.apache.hive.jdbc.HiveDriver";
    private static final String METADATA_TYPE = "TABLE";
    private static final String COLUMN_LABEL = "TABLE_NAME";
    private static final String HIVE_JDBC_PREFIX = "jdbc:hive2";
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(HIVE_JDBC_PREFIX)) {
            throw new Exception("hive server url should start with jdbc:hive2");
        }
        try {
            Class.forName(HIVE_DRIVER_CLASS);
            Connection conn = DriverManager.getConnection(url, user, password);
            LOGGER.info("get hive connection success, url={}", (Object)url);
            return conn;
        }
        catch (Exception e) {
            String errMsg = "get hive connection error, please check hive jdbc url, username or password";
            LOGGER.error(errMsg, (Throwable)e);
            throw new Exception(errMsg + ", error: " + e.getMessage());
        }
    }

    public static void executeSql(String sql, String url, String user, String password) throws Exception {
        try (Connection conn = HiveJdbcUtils.getConnection(url, user, password);
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOGGER.info("execute sql [{}] success for url: {}", (Object)sql, (Object)url);
        }
    }

    public static void createDb(String url, String user, String password, String dbName) throws Exception {
        String createDbSql = SqlBuilder.buildCreateDbSql(dbName);
        HiveJdbcUtils.executeSql(createDbSql, url, user, password);
    }

    public static void createTable(String url, String user, String password, HiveTableInfo tableInfo) throws Exception {
        String createTableSql = SqlBuilder.buildCreateTableSql(tableInfo);
        HiveJdbcUtils.executeSql(createTableSql, url, user, password);
    }

    public static List<String> getTables(String url, String user, String password, String dbName) throws Exception {
        try (Connection conn = HiveJdbcUtils.getConnection(url, user, password);){
            HiveDatabaseMetaData metaData = (HiveDatabaseMetaData)conn.getMetaData();
            ResultSet rs = metaData.getTables(dbName, dbName, null, new String[]{METADATA_TYPE});
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                String tableName = rs.getString(COLUMN_LABEL);
                tables.add(tableName);
            }
            rs.close();
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public static List<HiveColumnInfo> getColumns(String url, String user, String password, String dbName, String tableName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addColumns(String url, String user, String password, String dbName, String tableName, List<HiveColumnInfo> columnList) throws Exception {
        String addColumnSql = SqlBuilder.buildAddColumnSql(dbName, tableName, columnList);
        HiveJdbcUtils.executeSql(addColumnSql, url, user, password);
    }
}

