/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.iceberg;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSinkDTO;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergTableInfo;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.iceberg.IcebergCatalogUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;

    @Override
    public Boolean accept(SinkType sinkType) {
        return SinkType.ICEBERG == sinkType;
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (GlobalConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create iceberg table for sinkInfo={}", (Object)sinkInfo);
        IcebergSinkDTO icebergInfo = IcebergSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        List<IcebergColumnInfo> columnInfoList = this.getColumnList(sinkInfo);
        if (CollectionUtils.isEmpty(columnInfoList)) {
            throw new IllegalArgumentException("no iceberg columns specified");
        }
        IcebergTableInfo tableInfo = IcebergSinkDTO.getIcebergTableInfo((IcebergSinkDTO)icebergInfo, columnInfoList);
        String metastoreUri = icebergInfo.getCatalogUri();
        String warehouse = icebergInfo.getWarehouse();
        String dbName = icebergInfo.getDbName();
        String tableName = icebergInfo.getTableName();
        try {
            IcebergCatalogUtils.createDb(metastoreUri, warehouse, dbName);
            boolean tableExists = IcebergCatalogUtils.tableExists(metastoreUri, dbName, tableName);
            if (!tableExists) {
                IcebergCatalogUtils.createTable(metastoreUri, warehouse, tableInfo);
            } else {
                List<IcebergColumnInfo> existColumns = IcebergCatalogUtils.getColumns(metastoreUri, dbName, tableName);
                List<IcebergColumnInfo> needAddColumns = tableInfo.getColumns().stream().skip(existColumns.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    IcebergCatalogUtils.addColumns(metastoreUri, dbName, tableName, needAddColumns);
                    LOGGER.info("{} columns added for table {}", (Object)needAddColumns.size(), (Object)tableName);
                }
            }
            String info = "success to create iceberg resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo = {}", (Object)info);
        }
        catch (Throwable e) {
            String errMsg = "create iceberg table failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    private List<IcebergColumnInfo> getColumnList(SinkInfo sinkInfo) {
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        ArrayList<IcebergColumnInfo> columnList = new ArrayList<IcebergColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            IcebergColumnInfo column = IcebergColumnInfo.getFromJson((String)field.getExtParams());
            column.setName(field.getFieldName());
            column.setType(field.getFieldType());
            column.setDesc(field.getFieldComment());
            column.setRequired(field.getIsRequired() != null && field.getIsRequired() > 0);
            columnList.add(column);
        }
        return columnList;
    }
}

