/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresTableInfo;
import org.apache.inlong.manager.service.resource.postgres.PostgresSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresJdbcUtils {
    private static final String POSTGRES_DRIVER_CLASS = "org.postgresql.Driver";
    private static final String SCHEMA_PATTERN = "public";
    private static final String TABLE_TYPE = "TABLE";
    private static final String COLUMN_LABEL_TABLE = "TABLE_NAME";
    private static final String COLUMN_LABEL_COUNT = "count";
    private static final String POSTGRES_JDBC_PREFIX = "jdbc:postgresql";
    private static final Logger LOG = LoggerFactory.getLogger(PostgresJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(POSTGRES_JDBC_PREFIX)) {
            throw new Exception("Postgres server URL was invalid, it should start with jdbc:postgresql");
        }
        try {
            Class.forName(POSTGRES_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get postgres connection error, please check postgres jdbc url, username or password!";
            LOG.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg + " other error msg: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get postgres connection failed, please contact administrator");
        }
        LOG.info("get postgres connection success, url={}", (Object)url);
        return conn;
    }

    public static boolean executeSql(String sql, String url, String user, String password) throws Exception {
        try (Connection conn = PostgresJdbcUtils.getConnection(url, user, password);){
            Statement stmt = conn.createStatement();
            LOG.info("execute sql [{}] success for url: {}", (Object)sql, (Object)url);
            boolean bl = stmt.execute(sql);
            return bl;
        }
    }

    public static ResultSet executeQuerySql(String sql, String url, String user, String password) throws Exception {
        try (Connection conn = PostgresJdbcUtils.getConnection(url, user, password);){
            Statement stmt = conn.createStatement();
            LOG.info("execute sql [{}] success for url: {}", (Object)sql, (Object)url);
            ResultSet resultSet = stmt.executeQuery(sql);
            return resultSet;
        }
    }

    public static void executeSqlBatch(List<String> sql, String url, String user, String password) throws Exception {
        try (Connection conn = PostgresJdbcUtils.getConnection(url, user, password);){
            Statement stmt = conn.createStatement();
            for (String entry : sql) {
                stmt.execute(entry);
            }
            LOG.info("execute sql [{}] success for url: {}", sql, (Object)url);
        }
    }

    public static void createDb(String url, String user, String password, String dbName) throws Exception {
        String checkDbSql = PostgresSqlBuilder.getCheckDatabase(dbName);
        ResultSet resultSet = PostgresJdbcUtils.executeQuerySql(checkDbSql, url, user, password);
        if (resultSet != null) {
            resultSet.next();
            if (resultSet.getInt(COLUMN_LABEL_COUNT) == 0) {
                String createDbSql = PostgresSqlBuilder.buildCreateDbSql(dbName);
                PostgresJdbcUtils.executeSql(createDbSql, url, user, password);
            }
        }
    }

    public static void createTable(String url, String user, String password, PostgresTableInfo tableInfo) throws Exception {
        String createTableSql = PostgresSqlBuilder.buildCreateTableSql(tableInfo);
        PostgresJdbcUtils.executeSql(createTableSql, url, user, password);
    }

    public static boolean checkTablesExist(String url, String user, String password, String dbName, String tableName) throws Exception {
        boolean result = false;
        try (Connection conn = PostgresJdbcUtils.getConnection(url, user, password);){
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet rs = metaData.getTables(conn.getCatalog(), SCHEMA_PATTERN, tableName, new String[]{TABLE_TYPE});
            if (rs != null) {
                rs.next();
                result = rs.getRow() > 0 && tableName.equals(rs.getString(COLUMN_LABEL_TABLE));
                LOG.info("check table exist for db={} table={}, result={}", new Object[]{dbName, tableName, result});
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static List<PostgresColumnInfo> getColumns(String url, String user, String password, String tableName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addColumns(String url, String user, String password, String tableName, List<PostgresColumnInfo> columnList) throws Exception {
        List<String> addColumnSql = PostgresSqlBuilder.buildAddColumnsSql(tableName, columnList);
        PostgresJdbcUtils.executeSqlBatch(addColumnSql, url, user, password);
    }
}

