/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.postgres;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.sink.SinkInfo;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresSinkDTO;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresTableInfo;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.service.resource.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.postgres.PostgresJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostgresResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper postgresFieldMapper;

    @Override
    public Boolean accept(SinkType sinkType) {
        return SinkType.POSTGRES == sinkType;
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOGGER.info("begin to create postgres res sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("postgres resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (GlobalConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create postgres table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.postgresFieldMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOGGER.warn("no postgres fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<PostgresColumnInfo> columnList = new ArrayList<PostgresColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            PostgresColumnInfo columnInfo = new PostgresColumnInfo();
            columnInfo.setName(field.getFieldName());
            columnInfo.setType(field.getFieldType());
            columnInfo.setDesc(field.getFieldComment());
            columnList.add(columnInfo);
        }
        try {
            PostgresSinkDTO pgInfo = PostgresSinkDTO.getFromJson((String)sinkInfo.getExtParams());
            PostgresTableInfo tableInfo = PostgresSinkDTO.getPostgresTableInfo((PostgresSinkDTO)pgInfo, columnList);
            String url = pgInfo.getJdbcUrl();
            String user = pgInfo.getUsername();
            String password = pgInfo.getPassword();
            String dbName = tableInfo.getDbName();
            String tableName = tableInfo.getTableName();
            PostgresJdbcUtils.createDb(url, user, password, dbName);
            boolean tableExists = PostgresJdbcUtils.checkTablesExist(url, user, password, dbName, tableName);
            if (!tableExists) {
                PostgresJdbcUtils.createTable(url, user, password, tableInfo);
            } else {
                List<PostgresColumnInfo> existColumns = PostgresJdbcUtils.getColumns(url, user, password, tableName);
                ArrayList columnNameList = new ArrayList();
                existColumns.forEach(e -> columnNameList.add(e.getName()));
                List<PostgresColumnInfo> needAddColumns = tableInfo.getColumns().stream().filter(pgcInfo -> !columnNameList.contains(pgcInfo.getName())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    PostgresJdbcUtils.addColumns(url, user, password, tableName, needAddColumns);
                }
            }
            String info = "success to create postgres resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e2) {
            String errMsg = "create postgres table failed: " + e2.getMessage();
            LOGGER.error(errMsg, e2);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOGGER.info("success create postgres table for data sink [" + sinkInfo.getId() + "]");
    }
}

