/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.postgres;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSqlBuilder.class);

    public static String getCheckDatabase(String dbName) {
        String sql = "SELECT datname FROM from pg_catalog.pg_database WHERE datname = '" + dbName + "'";
        LOGGER.info("check database sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE " + dbName;
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(PostgresTableInfo table) {
        StringBuilder sql = new StringBuilder();
        String dbTableName = table.getTableName();
        sql.append("CREATE TABLE ").append(dbTableName);
        sql.append(PostgresSqlBuilder.buildCreateColumnsSql(table.getColumns()));
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static List<String> buildAddColumnsSql(String tableName, List<PostgresColumnInfo> columnList) {
        List<String> columnInfoList = PostgresSqlBuilder.getColumnsInfo(columnList);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String columnInfo : columnInfoList) {
            String sql = "ALTER TABLE " + tableName + " ADD COLUMN " + columnInfo;
            resultList.add(sql);
        }
        LOGGER.info("add columns sql={}", resultList);
        return resultList;
    }

    private static String buildCreateColumnsSql(List<PostgresColumnInfo> columns) {
        List<String> columnList = PostgresSqlBuilder.getColumnsInfo(columns);
        String sql = " (" + StringUtils.join(columnList, (String)",") + ") ";
        LOGGER.info("create columns sql={}", (Object)sql);
        return sql;
    }

    private static List<String> getColumnsInfo(List<PostgresColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        for (PostgresColumnInfo columnInfo : columns) {
            String columnStr = columnInfo.getName() + " " + columnInfo.getType();
            columnList.add(columnStr);
        }
        return columnList;
    }

    public static String buildDescTableSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT att.attname as filedName, format_type(att.atttypid, att.atttypmod) as filedType FROM pg_attribute as att, pg_class as clz WHERE att.attrelid = clz.oid and att.attnum > 0 and clz.relname = '").append(tableName).append("';");
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

