/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.sort.util.DataFlowUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class CreateSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateSortConfigListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private StreamSinkService streamSinkService;
    @Autowired
    private DataFlowUtils dataFlowUtils;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        LOGGER.info("Create sort config for groupId={}", (Object)context.getProcessForm().getInlongGroupId());
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        GroupOperateType groupOperateType = form.getGroupOperateType();
        if (groupOperateType == GroupOperateType.SUSPEND || groupOperateType == GroupOperateType.DELETE) {
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = form.getGroupInfo();
        String groupId = groupInfo.getInlongGroupId();
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            LOGGER.warn("GroupId is null for context={}", (Object)context);
            return ListenerResult.success();
        }
        List<StreamSink> streamSinks = this.streamSinkService.listSink(groupId, null);
        if (CollectionUtils.isEmpty(streamSinks)) {
            LOGGER.warn("Sink not found by groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        try {
            InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
            extInfo.setInlongGroupId(groupId);
            extInfo.setKeyName("dataFlow");
            if (groupInfo.getExtList() == null) {
                groupInfo.setExtList((List)Lists.newArrayList());
            }
            this.upsertDataFlow(groupInfo, extInfo);
        }
        catch (Exception e) {
            LOGGER.error("create sort config failed for sink list={} ", streamSinks, (Object)e);
            throw new WorkflowListenerException("create sort config failed: " + e.getMessage());
        }
        return ListenerResult.success();
    }

    private void upsertDataFlow(InlongGroupInfo groupInfo, InlongGroupExtInfo extInfo) {
        groupInfo.getExtList().removeIf(ext -> "dataFlow".equals(ext.getKeyName()));
        groupInfo.getExtList().add(extInfo);
    }

    public boolean async() {
        return false;
    }
}

