/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSource;
import org.apache.inlong.manager.common.pojo.source.pulsar.PulsarSource;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.sort.util.ExtractNodeUtils;
import org.apache.inlong.manager.service.sort.util.LoadNodeUtils;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.sort.protocol.GroupInfo;
import org.apache.inlong.sort.protocol.StreamInfo;
import org.apache.inlong.sort.protocol.enums.PulsarScanStartupMode;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.transformation.relation.NodeRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateSortConfigListenerV2
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateSortConfigListenerV2.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private InlongClusterService clusterService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        log.info("Create sort config V2 for groupId={}", (Object)context.getProcessForm().getInlongGroupId());
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        GroupOperateType groupOperateType = form.getGroupOperateType();
        if (groupOperateType == GroupOperateType.SUSPEND || groupOperateType == GroupOperateType.DELETE) {
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = form.getGroupInfo();
        List streamInfos = form.getStreamInfos();
        String groupId = groupInfo.getInlongGroupId();
        GroupInfo configInfo = this.createGroupInfo(groupInfo, streamInfos);
        String dataFlows = OBJECT_MAPPER.writeValueAsString((Object)configInfo);
        InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
        extInfo.setInlongGroupId(groupId);
        extInfo.setKeyName("dataFlow");
        extInfo.setKeyValue(dataFlows);
        if (groupInfo.getExtList() == null) {
            groupInfo.setExtList((List)Lists.newArrayList());
        }
        this.upsertDataFlow(groupInfo, extInfo);
        return ListenerResult.success();
    }

    private GroupInfo createGroupInfo(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfoList) {
        String groupId = groupInfo.getInlongGroupId();
        List<StreamSink> streamSinks = this.sinkService.listSink(groupId, null);
        Map sinkMap = streamSinks.stream().collect(Collectors.groupingBy(StreamSink::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        Map<String, List<StreamSource>> sourceMap = this.createPulsarSources(groupInfo, streamInfoList);
        ArrayList<StreamInfo> streamInfos = new ArrayList<StreamInfo>();
        for (InlongStreamInfo inlongStream : streamInfoList) {
            String streamId = inlongStream.getInlongStreamId();
            StreamInfo streamInfo = new StreamInfo(streamId, this.createNodesForStream(sourceMap.get(streamId), (List)sinkMap.get(streamId)), this.createNodeRelationsForStream(sourceMap.get(streamId), (List)sinkMap.get(streamId)));
            streamInfos.add(streamInfo);
        }
        return new GroupInfo(groupId, streamInfos);
    }

    private Map<String, List<StreamSource>> createPulsarSources(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfoList) {
        if (!"PULSAR".equals(groupInfo.getMqType())) {
            String errMsg = String.format("Unsupported MQ type %s", groupInfo.getMqType());
            log.error(errMsg);
            throw new WorkflowListenerException(errMsg);
        }
        HashMap sourceMap = Maps.newHashMap();
        InlongClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "PULSAR");
        PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)clusterInfo;
        String adminUrl = pulsarCluster.getAdminUrl();
        String serviceUrl = pulsarCluster.getUrl();
        String tenant = StringUtils.isEmpty((CharSequence)pulsarCluster.getTenant()) ? "public" : pulsarCluster.getTenant();
        streamInfoList.forEach(streamInfo -> {
            PulsarSource pulsarSource = new PulsarSource();
            String streamId = streamInfo.getInlongStreamId();
            pulsarSource.setTenant(tenant);
            pulsarSource.setSourceName(streamId);
            pulsarSource.setNamespace(groupInfo.getMqResource());
            pulsarSource.setTopic(streamInfo.getMqResource());
            pulsarSource.setAdminUrl(adminUrl);
            pulsarSource.setServiceUrl(serviceUrl);
            pulsarSource.setInlongComponent(true);
            List<StreamSource> sourceInfos = this.sourceService.listSource(groupInfo.getInlongGroupId(), streamId);
            for (StreamSource sourceInfo : sourceInfos) {
                if (StringUtils.isEmpty((CharSequence)pulsarSource.getSerializationType()) && StringUtils.isNotEmpty((CharSequence)sourceInfo.getSerializationType())) {
                    pulsarSource.setSerializationType(sourceInfo.getSerializationType());
                }
                if (SourceType.forType((String)sourceInfo.getSourceType()) != SourceType.KAFKA) continue;
                pulsarSource.setPrimaryKey(((KafkaSource)sourceInfo).getPrimaryKey());
            }
            if (StringUtils.isEmpty((CharSequence)pulsarSource.getSerializationType())) {
                pulsarSource.setSerializationType(DataTypeEnum.CSV.getName());
            }
            pulsarSource.setScanStartupMode(PulsarScanStartupMode.EARLIEST.getValue());
            pulsarSource.setFieldList(streamInfo.getFieldList());
            sourceMap.computeIfAbsent(streamId, key -> Lists.newArrayList()).add(pulsarSource);
        });
        return sourceMap;
    }

    private List<Node> createNodesForStream(List<StreamSource> sources, List<StreamSink> streamSinks) {
        ArrayList nodes = Lists.newArrayList();
        nodes.addAll(ExtractNodeUtils.createExtractNodes(sources));
        nodes.addAll(LoadNodeUtils.createLoadNodes(streamSinks));
        return nodes;
    }

    private List<NodeRelation> createNodeRelationsForStream(List<StreamSource> sources, List<StreamSink> streamSinks) {
        NodeRelation relation = new NodeRelation();
        List inputs = sources.stream().map(StreamSource::getSourceName).collect(Collectors.toList());
        List outputs = streamSinks.stream().map(StreamSink::getSinkName).collect(Collectors.toList());
        relation.setInputs(inputs);
        relation.setOutputs(outputs);
        return Lists.newArrayList((Object[])new NodeRelation[]{relation});
    }

    private void upsertDataFlow(InlongGroupInfo groupInfo, InlongGroupExtInfo extInfo) {
        groupInfo.getExtList().removeIf(ext -> "dataFlow".equals(ext.getKeyName()));
        groupInfo.getExtList().add(extInfo);
    }

    public boolean async() {
        return false;
    }
}

