/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSource;
import org.apache.inlong.manager.common.pojo.source.pulsar.PulsarSource;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.sort.util.ExtractNodeUtils;
import org.apache.inlong.manager.service.sort.util.LoadNodeUtils;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.sort.protocol.GroupInfo;
import org.apache.inlong.sort.protocol.StreamInfo;
import org.apache.inlong.sort.protocol.enums.PulsarScanStartupMode;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.transformation.relation.NodeRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateStreamSortConfigListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateStreamSortConfigListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private StreamSourceService streamSourceService;
    @Autowired
    private StreamSinkService streamSinkService;
    @Autowired
    private InlongClusterService clusterService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        String streamId;
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        GroupOperateType groupOperateType = form.getGroupOperateType();
        if (groupOperateType == GroupOperateType.SUSPEND || groupOperateType == GroupOperateType.DELETE) {
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = form.getGroupInfo();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        List<StreamSink> streamSinks = this.streamSinkService.listSink(groupId, streamId = streamInfo.getInlongStreamId());
        if (CollectionUtils.isEmpty(streamSinks)) {
            log.warn("Sink not found by groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        try {
            List<StreamSource> sources = this.createPulsarSources(groupInfo, streamInfo);
            List<Node> nodes = this.createNodesForStream(sources, streamSinks);
            List<NodeRelation> nodeRelations = this.createNodeRelationsForStream(sources, streamSinks);
            StreamInfo sortStreamInfo = new StreamInfo(streamId, nodes, nodeRelations);
            GroupInfo sortGroupInfo = new GroupInfo(groupId, (List)Lists.newArrayList((Object[])new StreamInfo[]{sortStreamInfo}));
            String dataFlows = OBJECT_MAPPER.writeValueAsString((Object)sortGroupInfo);
            InlongStreamExtInfo extInfo = new InlongStreamExtInfo();
            extInfo.setInlongGroupId(groupId);
            extInfo.setInlongStreamId(streamId);
            String keyName = "dataFlow";
            extInfo.setKeyName(keyName);
            extInfo.setKeyValue(dataFlows);
            if (streamInfo.getExtList() == null) {
                groupInfo.setExtList((List)Lists.newArrayList());
            }
            this.upsertDataFlow(streamInfo, extInfo, keyName);
        }
        catch (Exception e) {
            log.error("create sort config failed for sink list={} of groupId={}, streamId={}", new Object[]{streamSinks, groupId, streamId, e});
            throw new WorkflowListenerException("create sort config failed: " + e.getMessage());
        }
        return ListenerResult.success();
    }

    private List<StreamSource> createPulsarSources(InlongGroupInfo groupInfo, InlongStreamInfo streamInfo) {
        if (!"PULSAR".equals(groupInfo.getMqType())) {
            String errMsg = String.format("Unsupported MQ type %s", groupInfo.getMqType());
            log.error(errMsg);
            throw new WorkflowListenerException(errMsg);
        }
        PulsarSource pulsarSource = new PulsarSource();
        String streamId = streamInfo.getInlongStreamId();
        pulsarSource.setSourceName(streamId);
        pulsarSource.setNamespace(groupInfo.getMqResource());
        pulsarSource.setTopic(streamInfo.getMqResource());
        InlongClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "PULSAR");
        PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)clusterInfo;
        String adminUrl = pulsarCluster.getAdminUrl();
        String serviceUrl = pulsarCluster.getUrl();
        pulsarSource.setAdminUrl(adminUrl);
        pulsarSource.setServiceUrl(serviceUrl);
        pulsarSource.setInlongComponent(true);
        List<StreamSource> sources = this.streamSourceService.listSource(groupInfo.getInlongGroupId(), streamId);
        for (StreamSource source : sources) {
            if (StringUtils.isEmpty((CharSequence)pulsarSource.getSerializationType()) && StringUtils.isNotEmpty((CharSequence)source.getSerializationType())) {
                pulsarSource.setSerializationType(source.getSerializationType());
            }
            if (SourceType.forType((String)source.getSourceType()) != SourceType.KAFKA) continue;
            pulsarSource.setPrimaryKey(((KafkaSource)source).getPrimaryKey());
        }
        pulsarSource.setScanStartupMode(PulsarScanStartupMode.EARLIEST.getValue());
        pulsarSource.setFieldList(streamInfo.getFieldList());
        return Lists.newArrayList((Object[])new StreamSource[]{pulsarSource});
    }

    private List<Node> createNodesForStream(List<StreamSource> sources, List<StreamSink> streamSinks) {
        ArrayList nodes = Lists.newArrayList();
        nodes.addAll(ExtractNodeUtils.createExtractNodes(sources));
        nodes.addAll(LoadNodeUtils.createLoadNodes(streamSinks));
        return nodes;
    }

    private List<NodeRelation> createNodeRelationsForStream(List<StreamSource> sources, List<StreamSink> streamSinks) {
        NodeRelation relation = new NodeRelation();
        List inputs = sources.stream().map(StreamSource::getSourceName).collect(Collectors.toList());
        List outputs = streamSinks.stream().map(StreamSink::getSinkName).collect(Collectors.toList());
        relation.setInputs(inputs);
        relation.setOutputs(outputs);
        return Lists.newArrayList((Object[])new NodeRelation[]{relation});
    }

    private void upsertDataFlow(InlongStreamInfo streamInfo, InlongStreamExtInfo extInfo, String keyName) {
        streamInfo.getExtList().removeIf(ext -> keyName.equals(ext.getKeyName()));
        streamInfo.getExtList().add(extInfo);
    }

    public boolean async() {
        return false;
    }
}

