/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.sort.util.DataFlowUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class PushSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushSortConfigListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private StreamSinkService streamSinkService;
    @Autowired
    private DataFlowUtils dataFlowUtils;
    @Autowired
    private ObjectMapper objectMapper;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to push sort config by context={}", (Object)context);
        }
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getGroupInfo().getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        String streamId = form.getInlongStreamId();
        List<StreamSink> streamSinks = this.streamSinkService.listSink(groupId, streamId);
        if (CollectionUtils.isEmpty(streamSinks)) {
            LOGGER.warn("Sink not found by groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        for (StreamSink streamSink : streamSinks) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sink info: {}", (Object)streamSink);
            }
            Integer sinkId = streamSink.getId();
            try {
                if (!LOGGER.isDebugEnabled()) continue;
            }
            catch (Exception e) {
                LOGGER.error("push sort config to zookeeper failed, sinkId={} ", (Object)sinkId, (Object)e);
                throw new WorkflowListenerException("push sort config to zookeeper failed: " + e.getMessage());
            }
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

