/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort;

import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDisabledSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperDisabledSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceForm = (GroupResourceProcessForm)processForm;
            InlongGroupInfo groupInfo = groupResourceForm.getGroupInfo();
            boolean enable = groupInfo.getEnableZookeeper() == 0 && MQType.forType((String)groupInfo.getMqType()) != MQType.NONE;
            log.info("zookeeper disabled was [{}] for groupId [{}]", (Object)enable, (Object)groupId);
            return enable;
        }
        if (processForm instanceof StreamResourceProcessForm) {
            StreamResourceProcessForm streamResourceForm = (StreamResourceProcessForm)processForm;
            InlongGroupInfo groupInfo = streamResourceForm.getGroupInfo();
            InlongStreamInfo streamInfo = streamResourceForm.getStreamInfo();
            boolean enable = groupInfo.getEnableZookeeper() == 0 && MQType.forType((String)groupInfo.getMqType()) != MQType.NONE;
            log.info("zookeeper disabled was [{}] for groupId [{}] and streamId [{}] ", new Object[]{enable, groupId, streamInfo.getInlongStreamId()});
            return enable;
        }
        log.info("zk disabled for groupId [{}]", (Object)groupId);
        return false;
    }
}

