/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort.light;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.transform.TransformResponse;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.sort.util.ExtractNodeUtils;
import org.apache.inlong.manager.service.sort.util.LoadNodeUtils;
import org.apache.inlong.manager.service.sort.util.NodeRelationUtils;
import org.apache.inlong.manager.service.sort.util.TransformNodeUtils;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.sort.protocol.GroupInfo;
import org.apache.inlong.sort.protocol.StreamInfo;
import org.apache.inlong.sort.protocol.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LightGroupSortListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightGroupSortListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private StreamSourceService sourceService;
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamTransformService transformService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        LOGGER.info("create sort config for light group, context={}", (Object)context);
        try {
            LightGroupResourceProcessForm processForm = (LightGroupResourceProcessForm)context.getProcessForm();
            InlongGroupInfo groupInfo = processForm.getGroupInfo();
            List streamInfos = processForm.getStreamInfos();
            String groupId = groupInfo.getInlongGroupId();
            GroupInfo configInfo = this.createGroupInfo(groupInfo, streamInfos);
            String dataFlows = OBJECT_MAPPER.writeValueAsString((Object)configInfo);
            InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
            extInfo.setInlongGroupId(groupId);
            extInfo.setKeyName("dataFlow");
            extInfo.setKeyValue(dataFlows);
            if (groupInfo.getExtList() == null) {
                groupInfo.setExtList((List)Lists.newArrayList());
            }
            this.upsertDataFlow(groupInfo, extInfo);
            return ListenerResult.success();
        }
        catch (Throwable t) {
            LOGGER.error("create sort config error: ", t);
            throw new WorkflowListenerException("create sort config error: " + t.getMessage());
        }
    }

    private GroupInfo createGroupInfo(InlongGroupInfo groupInfo, List<InlongStreamInfo> streamInfoList) {
        String groupId = groupInfo.getInlongGroupId();
        List<StreamSource> sourceInfos = this.sourceService.listSource(groupId, null);
        Map sourceMap = sourceInfos.stream().collect(Collectors.groupingBy(StreamSource::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List<StreamSink> streamSinks = this.sinkService.listSink(groupId, null);
        Map sinkMap = streamSinks.stream().collect(Collectors.groupingBy(StreamSink::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        List<TransformResponse> transformResponses = this.transformService.listTransform(groupId, null);
        Map transformMap = transformResponses.stream().collect(Collectors.groupingBy(TransformResponse::getInlongStreamId, HashMap::new, Collectors.toCollection(ArrayList::new)));
        ArrayList<StreamInfo> streamInfos = new ArrayList<StreamInfo>();
        for (InlongStreamInfo stream : streamInfoList) {
            String streamId = stream.getInlongStreamId();
            List<Node> nodes = this.createNodesForStream((List)sourceMap.get(streamId), (List)transformMap.get(streamId), (List)sinkMap.get(streamId));
            StreamInfo streamInfo = new StreamInfo(streamId, nodes, NodeRelationUtils.createNodeRelationsForStream(stream));
            streamInfos.add(streamInfo);
            List transformResponseList = (List)transformMap.get(streamId);
            NodeRelationUtils.optimizeNodeRelation(streamInfo, transformResponseList);
        }
        return new GroupInfo(groupInfo.getInlongGroupId(), streamInfos);
    }

    private List<Node> createNodesForStream(List<StreamSource> sourceInfos, List<TransformResponse> transformResponses, List<StreamSink> streamSinks) {
        ArrayList nodes = Lists.newArrayList();
        nodes.addAll(ExtractNodeUtils.createExtractNodes(sourceInfos));
        nodes.addAll(TransformNodeUtils.createTransformNodes(transformResponses));
        nodes.addAll(LoadNodeUtils.createLoadNodes(streamSinks));
        return nodes;
    }

    private void upsertDataFlow(InlongGroupInfo groupInfo, InlongGroupExtInfo extInfo) {
        groupInfo.getExtList().removeIf(ext -> "dataFlow".equals(ext.getKeyName()));
        groupInfo.getExtList().add(extInfo);
    }

    public boolean async() {
        return false;
    }
}

